Imports System.IO
Imports System.Data
Partial Class ClientCallback
    Inherits System.Web.UI.Page
    Implements System.Web.UI.ICallbackEventHandler


    ''' <summary>
    ''' Holds the result that will be send to the Page
    ''' </summary>
    Protected CallBackResult As String


    ''' <summary>
    ''' Manually add the scripts to make call backs
    ''' </summary>
    Sub Page_Load(ByVal sender As Object, ByVal e As _
        System.EventArgs) Handles Me.Load

        'Register the method that receives the call back result
        Dim ReceiverCallBackMethod As String
        ReceiverCallBackMethod = Page.ClientScript.GetCallbackEventReference(Me, "arg", "ReceiveCallBackResult", "context")
        'Register the method that makes the callback call
        Dim callbackMethod As String
        callbackMethod = "function CallServer(arg, context) { " & ReceiverCallBackMethod & "} ;"
        Page.ClientScript.RegisterClientScriptBlock(Me.GetType(), "CallServer", callbackMethod, True)
    End Sub


    ''' <summary>
    ''' The Event that proccess the Call Back
    ''' </summary>
    ''' <param name="eventArgument">Send values to proccess here</param>
    Public Sub RaiseCallbackEvent(ByVal eventArgument As String) _
    Implements System.Web.UI.ICallbackEventHandler.RaiseCallbackEvent
        'Proccess the Argument, because the argument MUST be a string
        'and we receive two values separated with a custome separator (|)
        'Get the name and Age
        Dim Name As String = eventArgument.Substring(0, eventArgument.IndexOf("|"))
        Dim Age As Integer = CInt(eventArgument.Substring(eventArgument.IndexOf("|") + 1))
        'Add the user 

        'The data source
        Dim DS As New DataSet
        'Check if the file exists
        Dim file As New FileInfo(Server.MapPath(Request.ApplicationPath) & "/Data.xml")
        If Not file.Exists Then
            DS.Tables.Add("Users")
            DS.Tables("Users").Columns.Add("User Name", GetType(String))
            DS.Tables("Users").Columns.Add("Age", GetType(Integer))
        Else
            DS.ReadXml(file.FullName)
        End If
        'Add the new user
        Dim user As DataRow = DS.Tables("Users").NewRow
        user(0) = Name
        user(1) = Age
        DS.Tables("Users").Rows.Add(user)
        'write the DS to the file
        DS.WriteXml(file.FullName, XmlWriteMode.WriteSchema)


        'Add the User to the 
        CallBackResult = "Added User Name:" & Name & " Age:" & Age.ToString & "    Added At:" & Date.Now
    End Sub


    ''' <summary>
    ''' This will return some data to the Caller Page
    ''' </summary>
    ''' <returns>a string with the user added, this can return string.empty</returns>
    Public Function GetCallbackResult() _
    As String Implements _
    System.Web.UI.ICallbackEventHandler.GetCallbackResult

        'return the callback result 
        Return CallBackResult

    End Function

End Class