using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    { 
        if (!IsPostBack)
        {
            gvTab.DataSource = GetDataTable();
            gvTab.DataBind();
        }
    }

    protected DataTable GetDataTable()
    {
        DataTable dTable = new DataTable();
        DataRow dRow = null;
        Random rnd = new Random();
        dTable.Columns.Add("n");
        dTable.Columns.Add("qbrtn");
        dTable.Columns.Add("sqrtn");

        for (int n = 1; n <= 10; ++n)
        {
            dRow = dTable.NewRow();

            dRow["n"] = n + ".";
            dRow["qbrtn"] = Math.Pow(n,1D/3D) + "";
            dRow["sqrtn"] = Math.Sqrt(n) + "";

            dTable.Rows.Add(dRow);
            dTable.AcceptChanges();
        }

        return dTable;
    }
}
