﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Expand/Collapse</title>

    <script type="text/javascript">
        var Grid = null;
        var UpperBound = 0;
        var LowerBound = 1;
        var CollapseImage = 'minus.gif';
        var ExpandImage = 'plus.gif';
        var IsExpanded = true;   
        var Rows = null;
        var n = 1;
        var TimeSpan = 25;
        
        window.onload = function()
        {
            Grid = document.getElementById('<%= this.gvTab.ClientID %>');
            UpperBound = parseInt('<%= this.gvTab.Rows.Count %>');
            Rows = Grid.getElementsByTagName('tr');
        }
        
        function Toggle(Image)
        {
            ToggleImage(Image);
            ToggleRows();  
        }    
        
        function ToggleImage(Image)
        {
            if(IsExpanded)
            {
                Image.src = ExpandImage;
                Image.title = 'Expand';
                Grid.rules = 'none';
                n = LowerBound;
                
                IsExpanded = false;
            }
            else
            {
                Image.src = CollapseImage;
                Image.title = 'Collapse';
                Grid.rules = 'cols';
                n = UpperBound;
                
                IsExpanded = true;
            }
        }
        
        function ToggleRows()
        {
            if (n < LowerBound || n > UpperBound)  return;
                            
            Rows[n].style.display = Rows[n].style.display == '' ? 'none' : '';
            if(IsExpanded) n--; else n++;
            setTimeout("ToggleRows()",TimeSpan);
        }
    </script>

</head>
<body>
    <form id="form1" runat="server">
        <div>
            <asp:GridView ID="gvTab" BackColor="WhiteSmoke" runat="server" AutoGenerateColumns="False"
                GridLines="Vertical" ShowFooter="True">
                <Columns>
                    <asp:TemplateField>
                        <HeaderStyle Width="25px" />
                        <ItemStyle Width="25px" BackColor="White" />
                        <HeaderTemplate>
                            <asp:Image ID="imgTab" onclick="javascript:Toggle(this);" runat="server" ImageUrl="~/minus.gif"
                                ToolTip="Collapse" />
                        </HeaderTemplate>
                    </asp:TemplateField>
                    <asp:BoundField HeaderText="n" DataField="n">
                        <HeaderStyle Width="25px" />
                        <ItemStyle Width="25px" />
                    </asp:BoundField>
                    <asp:BoundField HeaderText="sqrt(n)" DataField="sqrtn">
                        <HeaderStyle Width="150px" />
                        <ItemStyle Width="150px" />
                    </asp:BoundField>
                    <asp:BoundField HeaderText="qbrt(n)" DataField="qbrtn">
                        <HeaderStyle Width="150px" />
                        <ItemStyle Width="150px" />
                    </asp:BoundField>
                </Columns>
                <HeaderStyle Height="25px" Font-Bold="True" BackColor="DimGray" ForeColor="White"
                    HorizontalAlign="Center" VerticalAlign="Middle" />
                <RowStyle Height="25px" BackColor="Gainsboro" HorizontalAlign="Center" VerticalAlign="Middle" />
                <AlternatingRowStyle Height="25px" BackColor="LightGray" HorizontalAlign="Center"
                    VerticalAlign="Middle" />
                <FooterStyle BackColor="Gray" />
            </asp:GridView>
        </div>
    </form>
</body>
</html>
