using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.ComponentModel;

namespace CustomControls
{
    /// <summary>
    /// Summary description for CustomDropDown
    /// </summary>
    [DefaultProperty("InnerText"),
          ToolboxData("<{0}:CustomDropDown runat=server></{0}:CustomDropDown>")]

    public class CustomDropDown : System.Web.UI.WebControls.DropDownList, ICustomControl
    {
        private string innerText;
        private string separator = "";
        public CustomDropDown()
        {
        }
        [Localizable(true)]
        [Bindable(true),
             Category("Appearance"),
             DefaultValue("")]
		//The text to be parsed into items
        public string InnerText
        {
            get
            {
                return innerText;
            }

            set
            {
                innerText = value;
            }
        }
        [Localizable(true)]
        [Bindable(true),
             Category("Appearance"),
             DefaultValue("")]
		//The separator to split the source text
        public string Separator
        {
            get
            {
                return separator;
            }

            set
            {
                separator = value;
            }
        }
		//Preparing the source text: parsing, spliting and filling the list
		//of items
        public void Prepare()
        {
            if (innerText == string.Empty || innerText == "")
                return;
            if (Items.Count > 0)
                return;
            string sep = separator == "" ? "@" : separator;
            innerText = innerText.Replace("</option><option>", sep);
            innerText = innerText.Replace("</option>\r\n<option>", sep);
            innerText = innerText.Replace("</option>", "");
            innerText = innerText.Replace("<option>", "");
            innerText = innerText.Replace("&#151;", "-");
            innerText = innerText.Replace("&#146;", "'");
            string[] cc = innerText.Split(new string[] { sep },
                StringSplitOptions.RemoveEmptyEntries);
            foreach (string c in cc)
            {
                this.Items.Add(new ListItem(c));
            }        
        }
        protected override void OnLoad(EventArgs e)
        {
            base.OnLoad(e);
            Prepare();
        }
    }
}