using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace TaskManager
{
    public partial class TaskList : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
            if (ViewState["StartDate"] != null)
            {
                ((Calendar)grdTaskManager.Rows[grdTaskManager.EditIndex].Cells[5].Controls[1]).SelectedDate = (DateTime)ViewState["StartDate"];
            }

            if (ViewState["EndDate"] != null)
            {
                ((Calendar)grdTaskManager.Rows[grdTaskManager.EditIndex].Cells[6].Controls[1]).SelectedDate = (DateTime)ViewState["EndDate"];
            }
        }

        protected void Calendar1_SelectionChanged(object sender, EventArgs e)
        {
            ViewState["StartDate"] = ((Calendar)grdTaskManager.Rows[grdTaskManager.EditIndex].Cells[5].Controls[1]).SelectedDate;
        }

        protected void Calendar2_SelectionChanged(object sender, EventArgs e)
        {
            ViewState["EndDate"] = ((Calendar)grdTaskManager.Rows[grdTaskManager.EditIndex].Cells[6].Controls[1]).SelectedDate;
        }

        protected void odsTaskManager_Updating(object sender, SqlDataSourceCommandEventArgs e)
        {
            if (ViewState["StartDate"] != null)
            {
                e.Command.Parameters["@StartDate"].Value = ((DateTime)ViewState["StartDate"]).ToString();
                ViewState.Remove("StartDate");
            }

            if (ViewState["EndDate"] != null)
            {
                e.Command.Parameters["@EndDate"].Value = ((DateTime)ViewState["EndDate"]).ToString();
                ViewState.Remove("EndDate");
            }

            if (txtTaskDescription.Text.Length > 0)
            {
                e.Command.Parameters["@TaskDescription"].Value = txtTaskDescription.Text;
            }

            if (txtComments.Text.Length > 0)
            {
                e.Command.Parameters["@Comments"].Value = txtComments.Text;
            }
        }

        protected void grdTaskManager_RowDataBound(object sender, GridViewRowEventArgs e)
        {
            if (e.Row.RowType == DataControlRowType.DataRow)
            {                
                switch (e.Row.RowState)
                {
                    case DataControlRowState.Normal:
                    case DataControlRowState.Alternate | DataControlRowState.Selected:
                    case DataControlRowState.Selected:
                        
                        ((LinkButton)e.Row.Cells[0].Controls[2]).OnClientClick = "return confirm('Do you want to delete this task?')";
                        break;

                    default:
                        break;
                }

                switch (e.Row.RowState)
                {
                    case DataControlRowState.Normal | DataControlRowState.Edit:
                    case DataControlRowState.Alternate | DataControlRowState.Edit:

                        if (ViewState["StartDate"] != null)
                        {
                            ((Calendar)e.Row.Cells[5].Controls[1]).SelectedDate = (DateTime)ViewState["StartDate"];
                        }

                        if (ViewState["EndDate"] != null)
                        {
                            ((Calendar)e.Row.Cells[6].Controls[1]).SelectedDate = (DateTime)ViewState["EndDate"];
                        }
                        break;

                    default:
                        break;
                }
            }
        }

        protected void grdTaskManager_SelectedIndexChanged(object sender, EventArgs e)
        {
            txtTaskDescription.Text = ((Label)grdTaskManager.SelectedRow.Cells[10].Controls[1]).Text;
            txtComments.Text = ((Label)grdTaskManager.SelectedRow.Cells[11].Controls[1]).Text;
        }

        protected void odsTaskManager_Deleting(object sender, SqlDataSourceCommandEventArgs e)
        {
            e.Command.Parameters["@DeletedBy"].Value = User.Identity.Name;
        }

        protected void grdTaskManager_RowUpdated(object sender, GridViewUpdatedEventArgs e)
        {
            txtTaskDescription.Text = String.Empty;
            txtComments.Text = String.Empty;
        }

        protected void grdTaskManager_PageIndexChanging(object sender, GridViewPageEventArgs e)
        {
            txtTaskDescription.Text = String.Empty;
            txtComments.Text = String.Empty;

            if (grdTaskManager.SelectedIndex > -1)
            {
                grdTaskManager.SelectedIndex = -1;
            }
        }

        protected void grdTaskManager_RowCommand(object sender, GridViewCommandEventArgs e)
        {
            if (e.CommandName.ToUpper() == "EDIT")
            {
                if (grdTaskManager.SelectedRow == null)
                {
                    txtTaskDescription.Text = ((Label)grdTaskManager.Rows[Convert.ToInt32(e.CommandArgument)].Cells[10].Controls[1]).Text;
                    txtComments.Text = ((Label)grdTaskManager.Rows[Convert.ToInt32(e.CommandArgument)].Cells[11].Controls[1]).Text;
                }
            }
        }

        protected void grdTaskManager_DataBound(object sender, EventArgs e)
        {
            foreach (GridViewRow row in grdTaskManager.Rows)
            {
                try
                {
                    if (((Label)row.Cells[9].Controls[1]).Text.ToUpper() == "COMPLETED")
                    {
                        ((Label)row.Cells[9].Controls[1]).ForeColor = System.Drawing.Color.Red;
                        ((Label)row.Cells[9].Controls[1]).Font.Bold = true;
                    }
                }
                catch
                { }
            }
        }
    }
}
