<%@ Page Language="C#" AutoEventWireup="true" Codebehind="TaskList.aspx.cs" Inherits="TaskManager.TaskList" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>TaskList Viewer</title>
</head>
<body>
    <form id="form1" runat="server">
        <div style="text-align: left">
            <table cellpadding="4" cellspacing="0" width="100%" border="0" style="font-size: 12px;
                font-family: Arial; border-right: brown thin solid; border-top: brown thin solid;
                border-left: brown thin solid; border-bottom: brown thin solid;">
                <tr>
                    <td align="left" style="width: 50%; background-color: #a52a2a" valign="top">
                        <asp:Label ID="Label1" runat="server" Font-Bold="True" ForeColor="White" Text="TaskList Viewer"></asp:Label>
                    </td>
                    <td align="right" style="width: 52%; background-color: #a52a2a" valign="top">
                        <asp:HyperLink ID="hypPageGuidelines" runat="server" Font-Bold="True" Font-Size="12px"
                            ForeColor="#FFFFFF" NavigateUrl="~/PageGuidelines.aspx">Page Guidelines</asp:HyperLink>
                        &nbsp;&nbsp;&nbsp;
                        <asp:HyperLink ID="hyplTaskList" runat="server" Font-Bold="True" ForeColor="White"
                            NavigateUrl="~/Default.aspx">Create a TaskList</asp:HyperLink>
                    </td>
                </tr>
                <tr>
                    <td align="left" colspan="2" style="background-color: #fafad2; width: 100%" valign="top">
                    </td>
                </tr>
                <tr>
                    <td align="left" colspan="2" valign="top" style="width: 100%">
                        <asp:GridView ID="grdTaskManager" runat="server" AllowPaging="True" AllowSorting="True"
                            AutoGenerateColumns="False" AutoGenerateEditButton="True" AutoGenerateSelectButton="True"
                            CellPadding="4" DataKeyNames="TaskID" DataSourceID="odsTaskManager" ForeColor="Black"
                            GridLines="None" Width="100%" EnableViewState="False" 
                            OnRowDataBound="grdTaskManager_RowDataBound" PageSize="8"
                            OnSelectedIndexChanged="grdTaskManager_SelectedIndexChanged" AutoGenerateDeleteButton="True" OnPageIndexChanging="grdTaskManager_PageIndexChanging" OnRowUpdated="grdTaskManager_RowUpdated" OnRowCommand="grdTaskManager_RowCommand" OnDataBound="grdTaskManager_DataBound">
                            <FooterStyle BackColor="#990000" Font-Bold="True" ForeColor="White" />
                            <Columns>
                                <asp:TemplateField HeaderText="TaskID" InsertVisible="False" SortExpression="TaskID"
                                    Visible="False">
                                    <ItemTemplate>
                                        <asp:Label ID="Label1" runat="server" Text='<%# Bind("TaskID") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:BoundField DataField="TaskName" HeaderText="Task Name" SortExpression="TaskName" />
                                <asp:TemplateField HeaderText="Assigned By" SortExpression="AssignedBy">
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="DropDownList1" runat="server" DataSourceID="odsTeamMember"
                                            DataTextField="TeamMemberName" DataValueField="TeamMemberID" SelectedValue='<%# Bind("AssignedByID") %>'
                                            Width="200px">
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                    <ItemTemplate>
                                        <asp:Label ID="Label2" runat="server" Text='<%# Bind("AssignedBy") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Assigned To" SortExpression="AssignedTo">
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="DropDownList2" runat="server" DataSourceID="odsTeamMember"
                                            DataTextField="TeamMemberName" DataValueField="TeamMemberID" SelectedValue='<%# Bind("AssignedToID") %>'
                                            Width="200px">
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                    <ItemTemplate>
                                        <asp:Label ID="Label3" runat="server" Text='<%# Bind("AssignedTo") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Start Date" SortExpression="StartDate">
                                    <EditItemTemplate>
                                        <asp:Calendar ID="Calendar1" runat="server" BackColor="#FFFFCC" BorderColor="#FFCC66"
                                            BorderWidth="1px" DayNameFormat="Shortest" Font-Names="Verdana" Font-Size="8pt"
                                            ForeColor="#663399" Height="200px" OnSelectionChanged="Calendar1_SelectionChanged"
                                            SelectedDate='<%# Bind("StartDate") %>' ShowGridLines="True" VisibleDate='<%# Eval("StartDate") %>'
                                            Width="220px" EnableViewState="true">
                                            <SelectedDayStyle BackColor="#CCCCFF" Font-Bold="True" />
                                            <TodayDayStyle BackColor="#FFCC66" ForeColor="White" />
                                            <SelectorStyle BackColor="#FFCC66" />
                                            <OtherMonthDayStyle ForeColor="#CC9966" />
                                            <NextPrevStyle Font-Size="9pt" ForeColor="#FFFFCC" />
                                            <DayHeaderStyle BackColor="#FFCC66" Font-Bold="True" Height="1px" />
                                            <TitleStyle BackColor="#990000" Font-Bold="True" Font-Size="9pt" ForeColor="#FFFFCC" />
                                        </asp:Calendar>
                                    </EditItemTemplate>
                                    <ItemTemplate>
                                        <asp:Label ID="Label7" runat="server" Text='<%# Eval("StartDate") %>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle Width="100px" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="End Date" SortExpression="EndDate">
                                    <EditItemTemplate>
                                        <asp:Calendar ID="Calendar2" runat="server" BackColor="#FFFFCC" BorderColor="#FFCC66"
                                            BorderWidth="1px" DayNameFormat="Shortest" EnableViewState="true" Font-Names="Verdana"
                                            Font-Size="8pt" ForeColor="#663399" Height="200px" OnSelectionChanged="Calendar2_SelectionChanged"
                                            SelectedDate='<%# Bind("EndDate") %>' ShowGridLines="True" VisibleDate='<%# Eval("EndDate") %>'
                                            Width="220px">
                                            <SelectedDayStyle BackColor="#CCCCFF" Font-Bold="True" />
                                            <TodayDayStyle BackColor="#FFCC66" ForeColor="White" />
                                            <SelectorStyle BackColor="#FFCC66" />
                                            <OtherMonthDayStyle ForeColor="#CC9966" />
                                            <NextPrevStyle Font-Size="9pt" ForeColor="#FFFFCC" />
                                            <DayHeaderStyle BackColor="#FFCC66" Font-Bold="True" Height="1px" />
                                            <TitleStyle BackColor="#990000" Font-Bold="True" Font-Size="9pt" ForeColor="#FFFFCC" />
                                        </asp:Calendar>
                                    </EditItemTemplate>
                                    <ItemTemplate>
                                        <asp:Label ID="Label8" runat="server" Text='<%# Eval("EndDate") %>'></asp:Label>
                                    </ItemTemplate>
                                    <ItemStyle Width="100px" />
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Estimated Hours" SortExpression="EstimatedHours">
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="DropDownList3" runat="server" DataSourceID="odsTimeRequired"
                                            DataTextField="TimeRequiredInHours" DataValueField="TimeRequiredID" SelectedValue='<%# Bind("EstimatedTimeID") %>'>
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                    <ItemTemplate>
                                        <asp:Label ID="Label4" runat="server" Text='<%# Bind("EstimatedHours") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Actual Hours" SortExpression="ActualHours">
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="DropDownList4" runat="server" DataSourceID="odsTimeRequired"
                                            DataTextField="TimeRequiredInHours" DataValueField="TimeRequiredID" SelectedValue='<%# Bind("ActualTimeID") %>'>
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                    <ItemTemplate>
                                        <asp:Label ID="Label5" runat="server" Text='<%# Bind("ActualHours") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Status Name" SortExpression="StatusName">
                                    <EditItemTemplate>
                                        <asp:DropDownList ID="DropDownList5" runat="server" DataSourceID="odsStatus" DataTextField="StatusName"
                                            DataValueField="StatusID" SelectedValue='<%# Bind("StatusID") %>'>
                                        </asp:DropDownList>
                                    </EditItemTemplate>
                                    <ItemTemplate>
                                        <asp:Label ID="Label6" runat="server" Text='<%# Bind("StatusName") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="TaskDescription" InsertVisible="False" ShowHeader="False"
                                    SortExpression="TaskDescription" Visible="False">
                                    <ItemTemplate>
                                        <asp:Label ID="Label9" runat="server" Text='<%# Bind("TaskDescription") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                                <asp:TemplateField HeaderText="Comments" InsertVisible="False" ShowHeader="False"
                                    SortExpression="Comments" Visible="False">
                                    <ItemTemplate>
                                        <asp:Label ID="Label10" runat="server" Text='<%# Bind("Comments") %>'></asp:Label>
                                    </ItemTemplate>
                                </asp:TemplateField>
                            </Columns>
                            <RowStyle BackColor="#FFFBD6" ForeColor="#333333" />
                            <EmptyDataTemplate>
                                <table cellpadding="3" cellspacing="0" border="0" width="100%">
                                    <tr>
                                        <td align="center" style="color:white; background-color:#a52a2a;width:100%">
                                            <asp:Label ID="Label1" runat="server" Font-Bold="True" Text="TaskList Viewer"></asp:Label>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center" style="height: 21px;width:100%">
                                            <asp:Label ID="Label7" runat="server" Font-Bold="True" Text="There are no task list records in the repository"></asp:Label>
                                        </td>
                                    </tr>
                                </table>
                            </EmptyDataTemplate>
                            <SelectedRowStyle BackColor="#FFCC66" Font-Bold="True" ForeColor="Navy" />
                            <PagerStyle BackColor="#FFCC66" ForeColor="#333333" HorizontalAlign="Center" />
                            <HeaderStyle BackColor="#990000" Font-Bold="True" ForeColor="White" />
                            <AlternatingRowStyle BackColor="White" />
                        </asp:GridView>
                    </td>
                </tr>
            </table>
        </div>
        <br />
        <div style="text-align: left">
            <table border="0" cellpadding="4" cellspacing="0" style="font-size: 12px; width: 90%;
                font-family: Arial">
                <tr>
                    <td align="left" style="width: 156px" valign="top">
                        <asp:Label ID="Label10" runat="server" Font-Bold="True" Text="Task Description"></asp:Label></td>
                    <td align="left" valign="top">
                        <asp:TextBox ID="txtTaskDescription" runat="server" Columns="80" Height="90px" TextMode="MultiLine"></asp:TextBox></td>
                </tr>
                <tr>
                    <td align="left" style="width: 156px" valign="top">
                        <asp:Label ID="Label9" runat="server" Font-Bold="True" Text="Comments"></asp:Label></td>
                    <td align="left" valign="top">
                        <asp:TextBox ID="txtComments" runat="server" Columns="80" Height="75px" TextMode="MultiLine"></asp:TextBox></td>
                </tr>
            </table>
        </div>
        <asp:SqlDataSource ID="odsTimeRequired" runat="server" ConnectionString="<%$ ConnectionStrings:Indotronix %>"
            SelectCommand="SELECT [TimeRequiredID], [TimeRequiredInHours] FROM [TimeRequired]">
        </asp:SqlDataSource>
        <asp:SqlDataSource ID="odsTeamMember" runat="server" ConnectionString="<%$ ConnectionStrings:Indotronix %>"
            SelectCommand="SELECT [TeamMemberID], [TeamMemberName], [Designation] FROM [TeamMember]">
        </asp:SqlDataSource>
        <asp:SqlDataSource ID="odsStatus" runat="server" ConnectionString="<%$ ConnectionStrings:Indotronix %>"
            SelectCommand="SELECT [StatusID], [StatusName] FROM [Status]"></asp:SqlDataSource>
        <asp:SqlDataSource ID="odsTaskManager" runat="server"
            ConnectionString="<%$ ConnectionStrings:Indotronix %>"
            SelectCommand="SELECT TaM.TaskID, TaM.TaskName, TaM.TaskDescription, TaM.AssignedToID, TaM.AssignedByID, TaM.EstimatedTimeID, TaM.StartDate, TaM.EndDate, TaM.ActualTimeID, TaM.Comments, TaM.StatusID, TR.TimeRequiredInHours As EstimatedHours, TeM.TeamMemberName As AssignedBy, TeM.Designation, S.StatusName, TeM1.TeamMemberName AS AssignedTo, TR1.TimeRequiredInHours AS ActualHours FROM TaskManager TaM INNER JOIN TeamMember TeM ON TaM.AssignedByID = TeM.TeamMemberID INNER JOIN TeamMember AS TeM1 ON TaM.AssignedToID = TeM1.TeamMemberID INNER JOIN TimeRequired AS TR ON TaM.EstimatedTimeID = TR.TimeRequiredID INNER JOIN TimeRequired AS TR1 ON TaM.ActualTimeID = TR1.TimeRequiredID INNER JOIN Status S ON TaM.StatusID = S.StatusID WHERE DeletedBy IS NULL ORDER BY TaM.StartDate DESC"
            UpdateCommand="UPDATE TaskManager SET TaskName = @TaskName, AssignedToID = @AssignedToID, AssignedByID = @AssignedByID, EstimatedTimeID = @EstimatedTimeID, StartDate = @StartDate, EndDate = @EndDate, ActualTimeID = @ActualTimeID, StatusID = @StatusID, TaskDescription = @TaskDescription, Comments = @Comments WHERE (TaskID = @TaskID)" OnUpdating="odsTaskManager_Updating" 
            DeleteCommand="UPDATE dbo.TaskManager SET DeletedBy = @DeletedBy WHERE TaskID = @TaskID" OnDeleting="odsTaskManager_Deleting">
            <UpdateParameters>
                <asp:Parameter Name="TaskName" Type="String" />
                <asp:Parameter Name="AssignedToID" Type="Int32" />
                <asp:Parameter Name="AssignedByID" Type="Int32" />
                <asp:Parameter Name="EstimatedTimeID" Type="Int32" />
                <asp:Parameter Name="StartDate" Type="DateTime" />
                <asp:Parameter Name="EndDate" Type="DateTime" />
                <asp:Parameter Name="ActualTimeID" Type="Int32" />
                <asp:Parameter Name="StatusID" Type="Int32" />
                <asp:Parameter Name="TaskDescription" Type="String" />
                <asp:Parameter Name="Comments" Type="String" />
                <asp:Parameter Name="TaskID" Type="Int32" />
            </UpdateParameters>                
            <DeleteParameters>
                <asp:Parameter Name="DeletedBy" />
                <asp:Parameter Name="TaskID" />
            </DeleteParameters>
        </asp:SqlDataSource>
        &nbsp;
    </form>
</body>
</html>
