using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

namespace TaskManager
{
    public partial class _Default : System.Web.UI.Page
    {
        protected void Page_Load(object sender, EventArgs e)
        {
        }

        protected void btnAddTask_Click(object sender, EventArgs e)
        {
            try
            {
                odsTaskManager.Insert();
                lblConfirmation.Text = "A task was created in the repository.  Verify the same in TaskList viewer";
                txtTaskName.Text = String.Empty;
                txtTaskDescription.Text = String.Empty;
                txtComments.Text = String.Empty;
            }
            catch
            {
                lblConfirmation.Text = "An error occured while trying to create a task in the repository";
            }
        }

        protected void odsTaskManager_Inserting(object sender, SqlDataSourceCommandEventArgs e)
        {
            if (e.Command.Parameters["@StartDate"].Value == null)
            {
                e.Command.Parameters["@StartDate"].Value = cdrStartDate.VisibleDate.ToShortDateString();
            }

            if (e.Command.Parameters["@EndDate"].Value == null)
            {
                e.Command.Parameters["@EndDate"].Value = cdrStartDate.VisibleDate.ToShortDateString();
            }
        }
    }
}
