<%@ Page Language="C#" AutoEventWireup="true" Codebehind="Default.aspx.cs" Inherits="TaskManager._Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Add a new task</title>
</head>
<body>
    <form id="form1" runat="server">
        <div style="text-align: left">
            <table border="0" cellpadding="4" cellspacing="0" style="width: 80%; font-size: 12px;
                font-family: Arial; border-right: brown thin solid; border-top: brown thin solid;
                border-left: brown thin solid; border-bottom: brown thin solid;">
                <tr>
                    <th align="left" colspan="2" style="width: 80%; background-color: #A52A2A; color: white;"
                        valign="top">
                        <asp:Label ID="Label1" runat="server" Text="Create a TaskList" Font-Bold="true"></asp:Label>
                    </th>
                    <th align="right" colspan="2" style="width: 80%; background-color: #A52A2A;" valign="top">
                        <asp:HyperLink ID="hypPageGuidelines" runat="server" Font-Bold="True" Font-Size="12px" 
                            ForeColor="#FFFFFF" NavigateUrl="~/PageGuidelines.aspx">Page Guidelines</asp:HyperLink>
                        &nbsp;&nbsp;&nbsp;
                        <asp:HyperLink ID="hyplTaskList" runat="server" NavigateUrl="~/TaskList.aspx" 
                            ForeColor="White">TaskList Viewer</asp:HyperLink>                    
                    </th>
                </tr>
                <tr>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblTaskName" runat="server" Text="Task Name" Font-Bold="True"></asp:Label></td>
                    <td align="left" style="width: 22%; background-color: #FAFAD2" valign="top">
                        <asp:TextBox ID="txtTaskName" runat="server" MaxLength="50"></asp:TextBox></td>
                    <td align="left" style="width: 8%; background-color: #FAFAD2" valign="top">
                    </td>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                    </td>
                </tr>
                <tr>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblTaskDescription" runat="server" Text="Task Description" Font-Bold="True"></asp:Label></td>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top" colspan="3">
                        <asp:TextBox ID="txtTaskDescription" runat="server" Columns="80" Height="100px" MaxLength="8000" TextMode="MultiLine"></asp:TextBox></td>
                </tr>
                <tr>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblAssignedTo" runat="server" Text="Assigned To" Font-Bold="True"></asp:Label></td>
                    <td align="left" style="width: 22%; background-color: #FAFAD2" valign="top">
                        <asp:DropDownList ID="ddlAssignedTo" runat="server" Width="200px" DataSourceID="odsTeamMember" DataTextField="TeamMemberName" DataValueField="TeamMemberID">
                        </asp:DropDownList></td>
                    <td align="left" style="width: 8%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblAssignedBy" runat="server" Text="Assigned By" Font-Bold="True"></asp:Label></td>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:DropDownList ID="ddlAssignedBy" runat="server" Width="200px" DataSourceID="odsTeamMember" DataTextField="TeamMemberName" DataValueField="TeamMemberID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblEstimatedHours" runat="server" Text="Estimated Hours" Font-Bold="True"></asp:Label></td>
                    <td align="left" style="width: 22%; background-color: #FAFAD2" valign="top">
                        <asp:DropDownList ID="ddlEstimatedHours" runat="server" Width="100px" DataSourceID="odsTimeRequired" DataTextField="TimeRequiredInHours" DataValueField="TimeRequiredID">
                        </asp:DropDownList>
                    </td>
                    <td align="left" style="width: 8%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblActualHours" runat="server" Text="Actual Hours" Font-Bold="True"></asp:Label></td>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:DropDownList ID="ddlActualHours" runat="server" Width="100px" DataSourceID="odsTimeRequired" DataTextField="TimeRequiredInHours" DataValueField="TimeRequiredID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblStartDate" runat="server" Text="Start Date" Font-Bold="True"></asp:Label></td>
                    <td align="left" style="width: 22%; background-color: #FAFAD2" valign="top">
                        <asp:Calendar ID="cdrStartDate" runat="server" BackColor="#FFFFCC" BorderColor="#FFCC66"
                            BorderWidth="1px" DayNameFormat="Shortest" Font-Names="Verdana" Font-Size="8pt"
                            ForeColor="#663399" Height="200px" ShowGridLines="True" Width="220px" VisibleDate="2007-11-19">
                            <SelectedDayStyle BackColor="#CCCCFF" Font-Bold="True" />
                            <TodayDayStyle BackColor="#FFCC66" ForeColor="White" />
                            <SelectorStyle BackColor="#FFCC66" />
                            <OtherMonthDayStyle ForeColor="#CC9966" />
                            <NextPrevStyle Font-Size="9pt" ForeColor="#FFFFCC" />
                            <DayHeaderStyle BackColor="#FFCC66" Font-Bold="True" Height="1px" />
                            <TitleStyle BackColor="#990000" Font-Bold="True" Font-Size="9pt" ForeColor="#FFFFCC" />
                        </asp:Calendar>
                    </td>
                    <td align="left" style="width: 8%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblEndDate" runat="server" Text="End Date" Font-Bold="True"></asp:Label></td>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:Calendar ID="cdrEndDate" runat="server" BackColor="#FFFFCC" BorderColor="#FFCC66"
                            BorderWidth="1px" DayNameFormat="Shortest" Font-Names="Verdana" Font-Size="8pt"
                            ForeColor="#663399" Height="200px" ShowGridLines="True"
                            Width="220px">
                            <SelectedDayStyle BackColor="#CCCCFF" Font-Bold="True" />
                            <TodayDayStyle BackColor="#FFCC66" ForeColor="White" />
                            <SelectorStyle BackColor="#FFCC66" />
                            <OtherMonthDayStyle ForeColor="#CC9966" />
                            <NextPrevStyle Font-Size="9pt" ForeColor="#FFFFCC" />
                            <DayHeaderStyle BackColor="#FFCC66" Font-Bold="True" Height="1px" />
                            <TitleStyle BackColor="#990000" Font-Bold="True" Font-Size="9pt" ForeColor="#FFFFCC" />
                        </asp:Calendar>
                    </td>
                </tr>
                <tr>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblComments" runat="server" Text="Comments" Font-Bold="True"></asp:Label></td>
                    <td align="left" colspan="3" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:TextBox ID="txtComments" runat="server" Columns="80" Height="50px" MaxLength="8000" TextMode="MultiLine"></asp:TextBox></td>
                </tr>
                <tr>
                    <td align="left" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:Label ID="lblStatus" runat="server" Font-Bold="True" Text="Status"></asp:Label></td>
                    <td align="left" colspan="3" style="width: 25%; background-color: #FAFAD2" valign="top">
                        <asp:DropDownList ID="ddlStatus" runat="server" Width="125px" BorderColor="" BorderStyle="NotSet" BorderWidth="" DataSourceID="odsStatus" DataTextField="StatusName" DataValueField="StatusID">
                        </asp:DropDownList>
                    </td>
                </tr>
                <tr>
                    <td align="left" style="width: 25%; background-color: #FAFAD2; height: 20px;" valign="top">
                    </td>
                    <td align="right" colspan="3" style="width: 75%; background-color: #FAFAD2; height: 20px;"
                        valign="top">
                        <asp:Button ID="btnAddTask" runat="server" Text="Add Task" OnClick="btnAddTask_Click"
                            OnClientClick='return confirm("Are you sure you entered correct data to create a task?");' />
                    </td>
                </tr>
                <tr>
                    <td align="left" colspan="4" style="width:100%;background-color:#FAFAD2;">
                        <asp:Label ID="lblConfirmation" runat="server" Text="" Font-Bold="true" ForeColor="Red"></asp:Label>
                    </td>
                </tr>
            </table>
        </div>
        <asp:SqlDataSource ID="odsTimeRequired" runat="server" ConnectionString="<%$ ConnectionStrings:Indotronix %>"
            SelectCommand="SELECT [TimeRequiredID], [TimeRequiredInHours] FROM [TimeRequired]">
        </asp:SqlDataSource>
        <asp:SqlDataSource ID="odsTeamMember" runat="server" ConnectionString="<%$ ConnectionStrings:Indotronix %>"
            SelectCommand="SELECT [TeamMemberID], [TeamMemberName], [Designation] FROM [TeamMember]">
        </asp:SqlDataSource>
        <asp:SqlDataSource ID="odsStatus" runat="server" ConnectionString="<%$ ConnectionStrings:Indotronix %>"
            SelectCommand="SELECT [StatusID], [StatusName] FROM [Status]"></asp:SqlDataSource>
        <asp:SqlDataSource ID="odsTaskManager" runat="server" ConnectionString="<%$ ConnectionStrings:Indotronix %>"
            InsertCommand="INSERT INTO TaskManager(TaskName, TaskDescription, AssignedToID, AssignedByID, EstimatedTimeID, StartDate, EndDate, ActualTimeID, Comments, StatusID) VALUES (@TaskName, @TaskDescription, @AssignedToID, @AssignedByID, @EstimatedTimeID, @StartDate, @EndDate, @ActualTimeID, @Comments, @StatusID)" OnInserting="odsTaskManager_Inserting">
            <InsertParameters>
                <asp:ControlParameter ControlID="txtTaskName" Direction="Input" Name="TaskName" PropertyName="Text" Type="String" />
                <asp:ControlParameter ControlID="txtTaskDescription" Direction="Input" Name="TaskDescription" PropertyName="Text" Type="String" />
                <asp:ControlParameter ControlID="ddlAssignedTo" Direction="Input" Name="AssignedToID" PropertyName="SelectedValue" Type="Int32" />
                <asp:ControlParameter ControlID="ddlAssignedBy" Direction="Input" Name="AssignedByID" PropertyName="SelectedValue" Type="Int32" />
                <asp:ControlParameter ControlID="ddlEstimatedHours" Direction="Input" Name="EstimatedTimeID" PropertyName="SelectedValue" Type="Int32" />
                <asp:ControlParameter ControlID="ddlActualHours" Direction="Input" Name="ActualTimeID" PropertyName="SelectedValue" Type="Int32" />
                <asp:ControlParameter ControlID="cdrStartDate" Direction="Input" Name="StartDate" PropertyName="SelectedDate" Type="DateTime" />
                <asp:ControlParameter ControlID="cdrEndDate" Direction="Input" Name="EndDate" PropertyName="SelectedDate" Type="DateTime" />
                <asp:ControlParameter ControlID="txtComments" Direction="Input" Name="Comments" PropertyName="Text" Type="String" />
                <asp:ControlParameter ControlID="ddlStatus" Direction="Input" Name="StatusID" PropertyName="SelectedValue" Type="Int32" />
            </InsertParameters>
        </asp:SqlDataSource>
    </form>
</body>
</html>
