using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
 
public partial class _Default : System.Web.UI.Page 
{
    #region constants
    const string NAME = "NAME";
    const string ID = "ID";
    #endregion

    protected void Page_Load(object sender, EventArgs e)
    {
        loadDynamicGridWithTemplateColumn();
    }

    private void loadDynamicGridWithTemplateColumn()
    {
        #region Code for preparing the DataTable

        //Create an instance of DataTable
        DataTable dt = new DataTable();
        
        //Create an ID column for adding to the Datatable
        DataColumn dcol = new DataColumn(ID, typeof(System.Int32));
        dcol.AutoIncrement = true;
        dt.Columns.Add(dcol);

        //Create an ID column for adding to the Datatable
        dcol = new DataColumn(NAME, typeof(System.String));
        dt.Columns.Add(dcol);

        //Now add data for dynamic columns
        //As the first column is auto-increment, we do not have to add any thing.
        //Let's add some data to the second column.
        for (int nIndex = 0; nIndex < 10; nIndex++)
        {
            //Create a new row
            DataRow drow = dt.NewRow();

            //Initialize the row data.
            drow[NAME] = "Row-" + Convert.ToString((nIndex + 1));

            //Add the row to the datatable.
            dt.Rows.Add(drow);
        }
        #endregion

        //Iterate through the columns of the datatable to set the data bound field dynamically.
        foreach (DataColumn col in dt.Columns)
        {
            //Declare the bound field and allocate memory for the bound field.
            TemplateField bfield = new TemplateField();

            //Initalize the DataField value.
            bfield.HeaderTemplate = new GridViewTemplate(ListItemType.Header, col.ColumnName);

            //Initialize the HeaderText field value.
            bfield.ItemTemplate = new GridViewTemplate(ListItemType.Item, col.ColumnName);

            //Add the newly created bound field to the GridView.
            GrdDynamic.Columns.Add(bfield);
        }

        //Initialize the DataSource
        GrdDynamic.DataSource = dt;

        //Bind the datatable with the GridView.
        GrdDynamic.DataBind();
    }
}