﻿using System;
using System.Collections;
using System.Configuration;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.HtmlControls;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Xml.Linq;


public partial class GridViewSelect : System.Web.UI.Page
{
    protected void DropDownList1_SelectedIndexChanged(object sender, EventArgs e)
    {
        GridView1.SetRowValueValueByCell(1, DropDownList1.SelectedValue);
    }
}

public static class GridViewExtensions
{
    public static void SetRowValueValueByCell(this GridView GridView, int CellNumber, string CellValue)
    {
        int intSelectedIndex = 0;
        int intPageIndex = 0;

        int intGridViewPages = GridView.PageCount;

        // Loop thru each page in the GridView
        for (int i = 0; i < intGridViewPages; i++)
        {
            // Set the current GridView page
            GridView.PageIndex = i;
            // Bind the GridView to the current page
            GridView.DataBind();
            // Loop thru each row in the GridView
            foreach (GridViewRow GVRow in GridView.Rows)
            {
                // Check to see if the value of GridView cell 2 matches
                // In this example cell 1 (0) is the select link
                if (GVRow.Cells[CellNumber].Text == CellValue)
                {
                    // If it is a mach set the variables and exit
                    intSelectedIndex = GVRow.RowIndex;
                    intPageIndex = i;
                    break;
                }
            }
        }

        // Set the GridView to the values found
        GridView.PageIndex = intPageIndex;
        GridView.SelectedIndex = intSelectedIndex;
        GridView.DataBind();
    }
}
