using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class _Default : System.Web.UI.Page 
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // Add weeknumbers
        addWeekNumberColumn();
    }

    private void addWeekNumberColumn()
    {
        // Get the date shown in the calendar control
        DateTime curMonth = Calendar1.VisibleDate;
        
        // Find first day of the current month
        curMonth = Convert.ToDateTime(curMonth.Year.ToString() + "-" + curMonth.Month.ToString() + "-01");

        // Build javascript
        string jscript = @"<script type='text/javascript'> 
                        addWkColumn('" + Calendar1.ClientID + "', " + getISOWeek(curMonth).ToString() + @");
                        </script>";

        // Add script to page for execution of addWkColumn javascript function
        Page.ClientScript.RegisterStartupScript(this.GetType(), "AddWeeknumbers", jscript);
    }


    private int getISOWeek(DateTime day)
    {
        return System.Globalization.CultureInfo.CurrentCulture.Calendar.GetWeekOfYear(day, System.Globalization.CalendarWeekRule.FirstFourDayWeek, DayOfWeek.Monday);
    }

}
