﻿using System;
using System.Web;
using ZipCodeObjects;

namespace LinqListGridBind_cs
{
    public partial class _Default : System.Web.UI.Page
    {
        /// <summary> 
        /// NumOfRowsToDisplay 
        /// </summary> 
        /// <remarks> 
        /// Number of records to fetch and display on each page. 
        /// </remarks> 
        const int NumOfRowsToDisplay = 20;

        /// <summary> 
        /// PageNumber 
        /// </summary> 
        /// <value></value> 
        /// <returns></returns> 
        /// <remarks> 
        /// Current Page Number 
        /// </remarks> 
        public int PageNumber
        {
            get { return Convert.ToInt32(this.Session["PageNumber"]); }
            set { Session["PageNumber"] = value; }
        }

        /// <summary> 
        /// Page_Load 
        /// </summary> 
        /// <param name="sender"></param> 
        /// <param name="e"></param> 
        /// <remarks></remarks> 
        protected void Page_Load(object sender, System.EventArgs e)
        {

            //only run on first load. 
            if (!Page.IsPostBack)
            {
                //set current page. 
                PageNumber = 1;
                Session["ResultsPerPage"] = NumOfRowsToDisplay;
                //update counter. 
                UpdateCounter();
                //set pager 
                SetPager();
            }

        }

        /// <summary> 
        /// SetPager 
        /// </summary> 
        /// <remarks></remarks> 
        private void SetPager()
        {
            //decide to show prev paging control 
            if (PageNumber == 1)
            {
                prevClick.Visible = false;
            }
            else
            {
                prevClick.Visible = true;
            }

            //decide to show prev paging control 
            if ((PageNumber * NumOfRowsToDisplay) >= ZipCodeObjects.ZipCodeCollection.SelectCount())
            {
                nextClick.Visible = false;
            }
            else
            {
                nextClick.Visible = true;
            }

            //decide to show paging seperator 
            if ((prevClick.Visible) & (nextClick.Visible))
            {
                pagingseperator.Visible = true;
            }
            else
            {
                pagingseperator.Visible = false;
            }
        }

        /// <summary> 
        /// UpdateCounter 
        /// </summary> 
        /// <remarks></remarks> 
        private void UpdateCounter()
        {
            //set status text
            Int32 bottom = ((PageNumber - 1) * NumOfRowsToDisplay) + 1;
            statustop.Text = "Now viewing " + bottom + " to " + PageNumber * NumOfRowsToDisplay + " out of " + ZipCodeObjects.ZipCodeCollection.SelectCount() + " records";

            //set code display 
            skip1.Text = Convert.ToString((PageNumber - 1) * NumOfRowsToDisplay);
            skip2.Text = skip1.Text;
            take1.Text = NumOfRowsToDisplay.ToString();
            take2.Text = NumOfRowsToDisplay.ToString();
        }

        /// <summary> 
        /// prevClick_Click 
        /// </summary> 
        /// <param name="sender"></param> 
        /// <param name="e"></param> 
        /// <remarks>user clicked previous button.</remarks> 
        protected void prevClick_Click(object sender, EventArgs e)
        {
            //decrease page number by one. 
            PageNumber = PageNumber - 1;
            //set pager 
            SetPager();
            //update counter. 
            UpdateCounter();
            //rebind grid. 
            ZipGrid.DataBind();
        }

        /// <summary> 
        /// nextClick_Click 
        /// </summary> 
        /// <param name="sender"></param> 
        /// <param name="e"></param> 
        /// <remarks>user clicked next button</remarks> 
        protected void nextClick_Click(object sender, EventArgs e)
        {
            //increase page number by one. 
            PageNumber = PageNumber + 1;
            //set pager 
            SetPager();
            //update counter. 
            UpdateCounter();
            //rebind grid. 
            ZipGrid.DataBind();
        }

    }
}
