﻿Partial Public Class _Default
    Inherits System.Web.UI.Page

    ''' <summary>
    ''' NumOfRowsToDisplay
    ''' </summary>
    ''' <remarks>
    ''' Number of records to fetch and display on each page.
    ''' </remarks>
    Const NumOfRowsToDisplay As Integer = 20

    ''' <summary>
    ''' PageNumber
    ''' </summary>
    ''' <value></value>
    ''' <returns></returns>
    ''' <remarks>
    ''' Current Page Number
    ''' </remarks>
    Public Property PageNumber() As Integer
        Get
            Return Session("PageNumber")
        End Get
        Set(ByVal value As Integer)
            Session("PageNumber") = value
        End Set
    End Property

    ''' <summary>
    ''' Page_Load
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks></remarks>
    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs) Handles Me.Load

        'only run on first load.
        If Not Page.IsPostBack Then
            'set current page.
            PageNumber = 1
            Session("ResultsPerPage") = NumOfRowsToDisplay
            'update counter.
            UpdateCounter()
            'set pager
            SetPager()
        End If

    End Sub

    ''' <summary>
    ''' SetPager
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub SetPager()
        'decide to show prev paging control
        If PageNumber = 1 Then
            prevClick.Visible = False
        Else
            prevClick.Visible = True
        End If

        'decide to show prev paging control
        If (PageNumber * NumOfRowsToDisplay) >= ZipCodeObjects.ZipCodeCollection.SelectCount() Then
            nextClick.Visible = False
        Else
            nextClick.Visible = True
        End If

        'decide to show paging seperator
        If (prevClick.Visible) And (nextClick.Visible) Then
            pagingseperator.Visible = True
        Else
            pagingseperator.Visible = False
        End If
    End Sub

    ''' <summary>
    ''' UpdateCounter
    ''' </summary>
    ''' <remarks></remarks>
    Private Sub UpdateCounter()
        'set status text
        statustop.Text = "Now viewing " & _
                        ((PageNumber - 1) * NumOfRowsToDisplay) + 1 & _
                        " to " & PageNumber * NumOfRowsToDisplay & _
                        " out of " & ZipCodeObjects.ZipCodeCollection.SelectCount() & " records"

        'set code display
        skip1.Text = (PageNumber - 1) * NumOfRowsToDisplay
        skip2.Text = skip1.Text
        take1.Text = NumOfRowsToDisplay
        take2.Text = NumOfRowsToDisplay
    End Sub

    ''' <summary>
    ''' prevClick_Click
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks>user clicked previous button.</remarks>
    Protected Sub prevClick_Click(ByVal sender As Object, ByVal e As EventArgs) Handles prevClick.Click
        'decrease page number by one.
        PageNumber = PageNumber - 1
        'set pager
        SetPager()
        'update counter.
        UpdateCounter()
        'rebind grid.
        ZipGrid.DataBind()
    End Sub

    ''' <summary>
    ''' nextClick_Click
    ''' </summary>
    ''' <param name="sender"></param>
    ''' <param name="e"></param>
    ''' <remarks>user clicked next button</remarks>
    Protected Sub nextClick_Click(ByVal sender As Object, ByVal e As EventArgs) Handles nextClick.Click
        'increase page number by one.
        PageNumber = PageNumber + 1
        'set pager
        SetPager()
        'update counter.
        UpdateCounter()
        'rebind grid.
        ZipGrid.DataBind()
    End Sub

End Class