<%@ Page Language="C#" %>

<%@ Register Src="Nav.ascx" TagName="Nav" TagPrefix="uc1" %>
<%@ Register Assembly="CustomGridFormatting" Namespace="CustomGridFormatting" TagPrefix="cc1" %>
<%@ Import Namespace="System.Data" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<script runat="server">
</script>

<html xmlns="http://www.w3.org/1999/xhtml" >
  <head>
    <title>Formatting Columns in a AutoGenerateColumns GridView</title>
    <style type="text/css"> body {font-family: 'Tahoma'; font-size: 10pt;}
            td {font-size: 10pt;}
            code {font-family: 'monospace'; font-size: 10pt; color: maroon;}
            code.blue {color: blue;}
            a {text-decoration: none; color: blue;}
    </style>
  </head>
  
  <body>
    <form id="Form1" runat="server">
        <uc1:Nav ID="Nav1" runat="server" />
        <h3>
            Formatting Columns in a AutoGenerateColumns GridView with an Extender</h3>
        
        <p>
            This is a simulation of a <code>GridView</code> accepting data from
            a source that provides dynamic columns.  This could, for example,
            be a stored procedure that presents sales-to-date totals by a
            category, where the columns could be quarters- or months-to-date.
            The values presented in this example are randomly generated.
            <br /><br />
            <code>AutoGenerateColumns</code> is set to <code class="blue">true</code>, and
            a custom extender (an implementation of <code>IExtenderProvider</code>)
            is used to apply formatting.
            With the 
            use of an <code>ObjectDataSource</code> and the <code>IExtenderProvider</code>
            object, this provides an entirely declarative solution.
            <br /><br />
            The custom extender adds a <b>UseCustomReportFormat</b> property to each
            <code>GridView</code> on the page.  The first <code>GridView</code> below 
            has this property set to <code class="blue">true</code>; the second has it set to 
            <code class="blue">false</code>.
        </p>        
        <hr />
        Number of dynamic value columns to present:
        <asp:DropDownList id="dd" runat="server" AutoPostBack="true" >
            <asp:ListItem text="1" value="1" />
            <asp:ListItem text="2" value="2" />
            <asp:ListItem text="3" value="3" />
            <asp:ListItem text="4" value="4" />
            <asp:ListItem text="5" value="5" Selected="True" />
        </asp:DropDownList>&nbsp;<br />
        
        <br />
        <asp:GridView ID="myList" runat="server"
                      Gridlines="None"
                      CellPadding="4"
                      BorderStyle="Solid"
                      BorderWidth="1px"
                      BorderColor="Black" DataSourceID="ObjectDataSource1"
                      >
        </asp:GridView>
        <br />
        <p>For comparison, the GridView below is identical to the first, 
           except that it is not using the custom extender.</p>
        <asp:GridView id="myList2" runat="server"
                      Gridlines="None"
                      CellPadding="4"
                      BorderStyle="Solid"
                      BorderWidth="1px"
                      BorderColor="Black" DataSourceID="ObjectDataSource1"
                      >
        </asp:GridView>
        <br />
        <cc1:CustomReportFormatExtender ID="CustomReportFormatExtender1" runat="server">
            <Props>
                <cc1:ExtenderProperties GridID="myList" UseCustomReportFormat="True" />
                <cc1:ExtenderProperties GridID="myList2" UseCustomReportFormat="False" />
            </Props>
        </cc1:CustomReportFormatExtender>
        <br />
        <asp:ObjectDataSource ID="ObjectDataSource1" runat="server" SelectMethod="CreateDataSource"
            TypeName="DataProvider">
            <SelectParameters>
                <asp:ControlParameter ControlID="dd" DefaultValue="5" Name="numValueColumns" PropertyName="SelectedValue"
                    Type="Int32" />
            </SelectParameters>
        </asp:ObjectDataSource>
        &nbsp;&nbsp;
    
    
    </form>
</body>
</html>
