<%@ Page Language="C#" %>

<%@ Register Src="Nav.ascx" TagName="Nav" TagPrefix="uc1" %>
<%@ Import Namespace="System.Data" %>

<script runat="server">
  
    // upon page load, initialize the list
    void Page_Load(object o, EventArgs e)
    {
        if (!IsPostBack)
        {
            dd.SelectedValue = "1";      
            BindData();     
        }
    }
    
    void BindData()
    {
        DataTable dt = DataProvider.CreateDataSource(Convert.ToInt32(dd.SelectedValue));
        
        myList.DataSource = dt;
        myList.DataBind();    
        
        myList2.DataSource = dt;
        myList2.DataBind();    
    }
    
    void ddChange(object o, EventArgs e)
    {
        BindData();
    }



    private int GetCellValue(TableCell tc)
    {
        int i = -1;
        
        try { i = Convert.ToInt32(tc.Text); }
        catch   { /* do nothing; */}        
        
        return i;
    }
    
    
    private void GV_RowDataBound(object o, GridViewRowEventArgs e)
    {        
        // apply custom formatting to data cells
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            // set formatting for the category cell
            TableCell cell = e.Row.Cells[0];
            cell.Width = new Unit("120px");
            cell.Style["border-right"] = "2px solid #666666";
            cell.BackColor = System.Drawing.Color.LightGray;
            
            // set formatting for value cells
            for(int i=1; i<e.Row.Cells.Count; i++)
            {
                cell = e.Row.Cells[i];
                
                // right-align each of the column cells after the first
                // and set the width
                cell.HorizontalAlign = HorizontalAlign.Right;
                cell.Width = new Unit("90px");
                
                // alternate background colors
                if (i % 2 == 1)
                    cell.BackColor 
                      =  System.Drawing.ColorTranslator.FromHtml("#EFEFEF");

                // check value columns for a high enough value
                // (value >= 8000) and apply special highlighting
                if (GetCellValue(cell) >= 8000)
                {
                    cell.Font.Bold = true;
                    cell.BorderWidth = new Unit("1px");
                    cell.BorderColor = System.Drawing.Color.Gray;
                    cell.BorderStyle = BorderStyle.Dotted;
                    cell.BackColor = System.Drawing.Color.Honeydew;
                }
                                      
            }                    
        }
        
        // apply custom formatting to the header cells
        if (e.Row.RowType == DataControlRowType.Header)
        {
            foreach (TableCell cell in e.Row.Cells)
            {
                cell.Style["border-bottom"] = "2px solid #666666";
                cell.BackColor=System.Drawing.Color.LightGray;
            }
        }
        
    }
    

</script>

<html>
  <head>
    <title>Formatting Columns in a AutoGenerateColumns GridView</title>
    <style type="text/css"> 
            body {font-family: 'Tahoma'; font-size: 10pt;}
            td {font-size: 10pt;}
            code {font-family: 'monospace'; font-size: 10pt; color: maroon;}
            code.blue {color: blue;}
            a {text-decoration: none; color: blue;}
    </style>
  </head>
  
  <body>
    <form id="Form1" runat="server">
        <uc1:Nav ID="Nav1" runat="server" />
        <h3>
            Formatting Columns in a AutoGenerateColumns GridView</h3>

        <p>
            This is a simulation of a <code>GridView</code> accepting data from
            a source that provides dynamic columns.  This could, for example,
            be a stored procedure that presents sales-to-date totals by a
            category, where the columns could be quarters- or months-to-date.
            The values presented in this example are randomly generated.
            <br /><br />
            <code>AutoGenerateColumns</code> is set to <code class="blue">true</code>, and
            a custom function is supplied for the <code>RowDataBound</code> event            
            to apply formatting.  Among other things, the function ensures
            that each dynamically added value column is right-aligned, and
            high sales numbers (numbers 8000 and above) are displayed with special
            hilighting.
        </p>        
        <hr />
        Number of dynamic value columns to present:
        <asp:DropDownList id="dd" runat="server" AutoPostBack="true" 
                          OnSelectedIndexChanged="ddChange">
            <asp:ListItem text="1" value="1" />
            <asp:ListItem text="2" value="2" />
            <asp:ListItem text="3" value="3" />
            <asp:ListItem text="4" value="4" />
            <asp:ListItem text="5" value="5" />
        </asp:DropDownList>
        
        <br /><br />
        
        <asp:GridView id="myList" runat="server"
                      AutoGenerateColumns="true"
                      Gridlines="none"
                      CellPadding="4"
                      BorderStyle="Solid"
                      BorderWidth="1"
                      BorderColor="Black"
                      OnRowDataBound="GV_RowDataBound"
                      >
        </asp:GridView>                      
        
        <br /><br />
        <p>For comparison, the GridView below is identical to the first, 
           except that its RowDataBound event is not trapped.</p>
        <asp:GridView id="myList2" runat="server"
                      AutoGenerateColumns="true"
                      Gridlines="none"
                      CellPadding="4"
                      BorderStyle="Solid"
                      BorderWidth="1"
                      BorderColor="Black"
                      >
        </asp:GridView>                      

    </form>
  </body>
  
</html>