using System;
using System.Collections.Generic;
using System.Text;

namespace CustomGridFormatting
{
    public class ExtenderProperties
    {
        private bool _useCustomReportFormat;
        private string _gridID;

        public bool UseCustomReportFormat
        {
            get { return _useCustomReportFormat; }
            set { _useCustomReportFormat = value; }
        }

        public string GridID
        {
            get { return _gridID; }
            set { _gridID = value; }
        }	
    }


    public class ExtenderPropertiesCollection : List<ExtenderProperties>
    {
        public bool GetUseCustomReportFormatForGridID(string gridID)
        {
            for (int index = 0; index < this.Count; index++)
            {
                if (this[index].GridID == gridID)
                {
                    return this[index].UseCustomReportFormat;
                }
            }
            return false;
        }

        public void SetUseCustomReportFormatForGridID(string gridID, bool value)
        {
            bool b = false;
            for (int index = 0; index < this.Count; index++)
            {
                if (this[index].GridID == gridID)
                {
                    this[index].UseCustomReportFormat = value;
                    b = true;
                    break;
                }
            }
            if (!b)
            {
                ExtenderProperties p = new ExtenderProperties();
                p.UseCustomReportFormat = value;
                p.GridID = gridID;
                this.Add(p);
            }
        }
    }
}
