using System;
using System.Collections.Generic;
using System.Text;
using System.Web.UI.Design;

namespace CustomGridFormatting
{
    class CustomReportFormatExtenderDesigner : ControlDesigner
    {
        public override string GetDesignTimeHtml()
        {
            string tmpl = "<span style='font-size: 8pt;'>"
                        + "To apply formatting, set the <b>UseCustomReportFormat</b> "
                        + "property on the desired GridView controls to <b>true</b>.  "
                        + "<br />{0}"
                        + "</span>";

            int iCount = 0;
            string lst = "<ul style='margin-top: 3px; margin-bottom: 3px;'>";
            foreach (ExtenderProperties p in ((CustomReportFormatExtender)Component).Props)
                if (p.UseCustomReportFormat)
                {
                    iCount++;
                    lst += "<li style='margin-top: 1px; margin-bottom: 2px;'>" + p.GridID + "</li>";
                }
            lst += "</ul>";

            string sDis = "";
            if (iCount > 0)
                sDis = string.Format("The extender will apply formatting to the following GridViews: {0}", lst);
            else
                sDis = "At present, no GridViews will be formatted by this extender.";

            string msg = string.Format(tmpl, sDis);
            return this.CreatePlaceHolderDesignTimeHtml(msg);
        }
    }
}
