﻿<%@ Page Language="C#" AutoEventWireup="true" CodeFile="Default.aspx.cs" Inherits="_Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.1//EN" "http://www.w3.org/TR/xhtml11/DTD/xhtml11.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Drag and Drop Shopping Cart Demo</title>
    <link href="Site.css" rel="stylesheet" type="text/css" />
    
     
</head>
<body id="documentBody">
    <form id="form1" runat="server">
        <asp:ScriptManager ID="ScriptManager1" runat="server" />
        <div>
        
       <div  id="dZone" style="position:absolute;top:237px; left:1147px; width:300px; overflow:auto; height:300px" class="DefaultDropZoneColor">
    Shopping Cart        
    
    Total: $ <div class="totalBox" id="divTotal">0.00</div>      
    </div>            
                               
                <asp:DataList  Height="100%" Width="100%" ID="dlToys" runat="server" RepeatColumns="3" CellPadding="20" CellSpacing="20">
                
               <ItemTemplate>           
                              
               <div ID="a" runat = "server" class="dragElement">
               <asp:Label ID="lblTitle" runat="server" Text='<%# Eval("Title") %>'  />
               <asp:Label ID="lblPrice" runat="server" Text = '<%# Eval("Price") %>' />
               <asp:Image ID="imgPicture" runat="server" ImageUrl='<%# Eval("ImageUrl") %>' />
               
               </div>          
                               
                </ItemTemplate>               
                 
                </asp:DataList>
                
                               
             </div>                 
        
    </form>
</body>
</html>

<script language="javascript" type="text/javascript">

var mouseState = 'up';
var clone = null; 
var totalPurchase = 0.0; 
var dropZoneArray = new Array(1); 
dropZoneArray[0] = "dZone";
var titlePattern = ".+_lblTitle$"
var pricePattern = ".+_lblPrice$"
var dragElementPattern = ".+_a$";

var uniqueNumber = 1; 

function ResetColor() 
{
    document.getElementById("dZone").className = 'DefaultDropZoneColor';   
}

function IsInDropZone(evtTarget) 
{     
    var result = false;  
   
    // iterate through the array and find it the id exists 
    for(i = 0; i < dropZoneArray.length; i++) 
    {
        if(evtTarget.id == dropZoneArray[i]) 
        {
            result = true; 
            break; 
        }
    } 
    
    return result;
}

function MakeElementDraggable(obj) 
{    
    var startX = 0; 
    var startY = 0; 
        
function InitiateDrag(e) 
{    
    mouseState = 'down';
    
    var evt = e || window.event;
    
    startX = parseInt(evt.clientX); 
    startY = parseInt(evt.clientY);    
    
    clone = obj.cloneNode(true);
           
    clone.style.position = 'absolute';   
    clone.style.top = parseInt(startY) + 'px';
    clone.style.left = parseInt(startX) + 'px';  
    
    document.body.appendChild(clone);     
    
    document.onmousemove = Drag;
    document.onmouseup = Drop;  
    
    return false;             
}

function Drop(e) 
{
       var evt = e || window.event;
       var evtTarget = evt.target || evt.srcElement;                          
            
       var dZone = document.getElementById("dZone"); 
        
        if( evt.clientX > dZone.offsetLeft && evt.clientX < (dZone.offsetLeft + dZone.offsetWidth) 
            && evt.clientY > dZone.offsetTop && evt.clientY < (dZone.offsetTop + dZone.offsetHeight))
            {               
                AddPrice(); 
            }    
              
        document.onmouseup = null; 
        document.onmousemove = null;               
       
        document.body.removeChild(clone); 
        mouseState = 'up';
        ResetColor();   
       
}

function AddPrice() 
{   
          
   var title = GetProductTitle();
   var price = GetProductPrice(); 
   
       
    var dZone = document.getElementById("dZone"); 
    var textNode = document.createTextNode(title);    
    var priceNode = document.createTextNode(price); 
        
    var spaceNode = document.createTextNode(':  $');   
    var paragraphElement = document.createElement('p');
    
    // create the delete button 
    
    var deleteButton = document.createElement('button');
    deleteButton.value = 'Delete';
    deleteButton.innerHTML = 'Delete';
    deleteButton.onclick = DeleteItem;
    
    var item = document.createElement('div'); 
    item.id = 'itemDiv' + uniqueNumber; 
      
    item.appendChild(paragraphElement);     
    item.appendChild(textNode); 
    item.appendChild(spaceNode); 
    item.appendChild(priceNode); 
    item.appendChild(spaceNode); 
    item.appendChild(deleteButton);
    
    dZone.appendChild(item);  
    
    // increment the price
    IncrementTotal(price);
    uniqueNumber++; 
    
}

function DeleteItem(e) 
{    
    var evt = e || window.event;
    var evtTarget = evt.target || evt.srcElement;
    
    if(IsFireFox()) 
    {
        price = evtTarget.parentNode.childNodes[2].nodeValue; 
        evtTarget.parentNode.parentNode.removeChild(evtTarget.parentNode); 
    }    
    else
    {      
    price = evtTarget.parentElement.childNodes[2].nodeValue;
    evtTarget.parentElement.parentElement.removeChild(evtTarget.parentElement); 
    } 
       
    DecrementTotal(price); 
}

function DecrementTotal(price) 
{
    totalPurchase -= Math.ceil(Number(price)); 
    document.getElementById("divTotal").innerHTML = totalPurchase; 
}

function IncrementTotal(price) 
{      
    totalPurchase += Math.ceil(Number(price)); 
    document.getElementById("divTotal").innerHTML = totalPurchase; 
}



function GetProductPrice() 
{
    var price = '';  
    
    if(IsFireFox()) {        
    price = (clone.childNodes[3].innerHTML);          
    }
    else price = (clone.childNodes[2].innerHTML); 
   
   
    return price;    
}

function GetProductTitle() 
{
   
    var title = '';   
    
    if(IsFireFox()) 
    {
    title = clone.childNodes[1].innerHTML; 
    
    }
    
    else { title = clone.childNodes[0].innerHTML;  }    
    
   return title; 
}

function IsFireFox() 
{
    if(navigator.appName == 'Netscape') 
     return true; 
     else return false; 
}


function Drag(e) 
{
   
    if(mouseState == 'down') {
      
    // only drag when the mouse is down  
    var evt = e || window.event;
    
    var evtTarget = evt.target || evt.srcElement;    
    
    clone.style.top = evt.clientY + 'px'; 
    clone.style.left = evt.clientX + 'px';
    
     // Check if we are in the drop Zone 
    if(IsInDropZone(evtTarget)) 
    {   
       
        evtTarget.className = 'highlightDropZone';       
    }
    
    else 
    {  
        ResetColor();          
    }
    
    } 
    
}

obj.onmousedown = InitiateDrag;

}

function IsMatch(id, pattern) 
{
    var regularExpresssion = new RegExp(pattern);
    if(id.match(regularExpresssion)) return true;
    else return false;
}

var divElements = document.getElementsByTagName("div");      

for(i=0;i<divElements.length;i++) 
{   
    
    if(IsMatch(divElements[i].id, dragElementPattern)) 
    {            
        MakeElementDraggable(divElements[i]);  
    }
}


</script>
