﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Net;
using System.IO;
using System.Drawing;
using System.Drawing.Imaging;
using System.ComponentModel;

public partial class DeepZoom : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
    }
    public string ImageUrl
    {
        get { return imageUrl.Value; }
        set
        {
            Bitmap bmp = GetTileImage.LoadImage(value);
            if (bmp == null)
                return;

            imageUrl.Value = value;
            int cx = bmp.Width;
            int cy = bmp.Height;
            int n = (int)Math.Ceiling(Math.Log(Math.Max(cx, cy), 2)) + 1;
            int size = (int)Math.Pow(2, n);

            if (cx > cy)
            {
                width.Value = size.ToString();
                height.Value = (size * cy / cx).ToString();
            }
            else
            {
                width.Value = (size * cx / cy).ToString();
                height.Value = size.ToString();
            }
        }
    }

    [Bindable(true), Category("Appearance"), DefaultValue("400px")]
    public Unit Width
    {
        get { return Unit.Parse(container.Style["width"]); }
        set { container.Style["width"] = value.ToString(); }
    }
    [Bindable(true), Category("Appearance"), DefaultValue("300px")]
    public Unit Height
    {
        get { return Unit.Parse(container.Style["height"]); }
        set { container.Style["height"] = value.ToString(); }
    }
    [Bindable(true), Category("Appearance"), DefaultValue("256")]
    public int TileSize
    {
        get { return int.Parse(tileSize.Value); }
        set { tileSize.Value = value.ToString(); }
    }
    [Bindable(true), Category("Appearance"), DefaultValue("1")]
    public int TileOverlap
    {
        get { return int.Parse(tileOverlap.Value); }
        set { tileOverlap.Value = value.ToString(); }
    }
}