﻿<%@ Control Language="C#" AutoEventWireup="true" CodeBehind="DeepZoom.ascx.cs" Inherits="DeepZoom" %>
<div id="container" runat="server" style="width: 400px; height: 300px; background-color: black;">
    <input id="width" type="hidden" runat="server" />
    <input id="height" type="hidden" runat="server" />
    <input id="imageUrl" type="hidden" runat="server" />
    <input id="tileSize" type="hidden" runat="server" value="256" />
    <input id="tileOverlap" type="hidden" runat="server" value="1" />
</div>
<script type="text/javascript" src="http://seadragon.com/ajax/0.8/seadragon-min.js"></script>
<script type="text/javascript">
    function Init() {
        var width = parseInt(document.getElementById("<%= width.ClientID %>").value);
        var height = parseInt(document.getElementById("<%= height.ClientID %>").value);
        var imageUrl = document.getElementById("<%= imageUrl.ClientID %>").value;
        var tileSize = parseInt(document.getElementById("<%= tileSize.ClientID %>").value);
        var tileOverlap = parseInt(document.getElementById("<%= tileOverlap.ClientID %>").value);
        var tileSource = new Seadragon.TileSource(width, height, tileSize, tileOverlap);
        tileSource.getTileUrl = function (level, x, y) {
            return "GetTileImage.ashx?level=" + level + "&x=" + x + "&y=" + y +
                   "&tileSize=" + tileSize + "&tileOverlap=" + tileOverlap + "&image=" + imageUrl;
        }

        var container = document.getElementById("<%= container.ClientID %>");
        var viewer = new Seadragon.Viewer(container);
        viewer.openTileSource(tileSource);
    }

    Seadragon.Utils.addEvent(window, "load", Init);
</script>
