﻿using System;
using System.Collections.Generic;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Linq;
using System.Web.UI.HtmlControls;


public partial class _Default : System.Web.UI.Page
{
    const int m_nPhotoId = 2;
    #region Events
    protected void Page_Load(object sender, EventArgs e)
    {
      tPhoto Photo   = Photos.GetPhotoById(m_nPhotoId);
      Image1.ImageUrl = Photo.sPath;
      HFShowFriends.Value = dlFriends.Items.Count == 0 ? "0" : "1";
      List<tTag> lstTags = Tags.GetTaggedFriends(m_nPhotoId);
      PopulateMap(lstTags);
      PopulateTags(lstTags);
    }
    protected void lbSelect_Command(object sender, CommandEventArgs e)
    {
        int nFriendId = Convert.ToInt32(e.CommandArgument);
        tTag tag = CreateTag(nFriendId);
        AddNewTag(tag, false);
        Friends.TagFriend(nFriendId, true);
        dlFriends.DataBind();
        dlTaggedFriends.DataBind();
        HFShowFriends.Value = dlFriends.Items.Count == 0 ? "0" : "1";
        dvFriends.Attributes["visibility"] = "hidden";
    }
    protected void lbRemoveTag_Command1(object sender, CommandEventArgs e)
    {
        int nFriendId = Convert.ToInt32(e.CommandArgument);
        Friends.TagFriend(nFriendId, false);
        Tags.RemoveTag(m_nPhotoId, nFriendId);

        HtmlGenericControl gcArea = new HtmlGenericControl("area");
        gcArea.Attributes.Add("id", nFriendId.ToString());
        mapPhoto.Controls.Remove(gcArea);

        dlTaggedFriends.DataBind();
        dlFriends.DataBind();
    }
    #endregion

    #region Methods
    private void PopulateTags(List<tTag> lstTags)
    {
        foreach (tTag t in lstTags)
        {
            AddNewTag(t, true); ;
        }
    }

    private void AddNewTag(tTag t, bool bExists)
    {
        if (!bExists)
            Tags.Add(t);
        AddNewArea(t);
    }

    private tTag CreateTag(int nFriendId)
    {
        tTag tag = new tTag();
        tag.nX1 = int.Parse(x1.Value);
        tag.nY1 = int.Parse(y1.Value);
        tag.nX2 = int.Parse(x2.Value);
        tag.nY2 = int.Parse(y2.Value);
        tag.nPhotoId = m_nPhotoId;
        tag.nFriendId = nFriendId;
        return tag;
    }

    private void PopulateMap(List<tTag> lstTags)
    {
        foreach (tTag t in lstTags)
        {
             AddNewArea(t);            
        }
    }

    private void AddNewArea(tTag t)
    {
        HtmlGenericControl gcArea = new HtmlGenericControl("area");
        gcArea.Attributes.Add("shape", "rect");
        gcArea.Attributes.Add("href", "#");
        string strFriendName = Friends.GetFriendName(t.nFriendId);
        gcArea.Attributes.Add("id", "a" + t.nFriendId.ToString());
        gcArea.Attributes.Add("title", strFriendName);
        gcArea.Attributes.Add("alt", strFriendName);
        gcArea.Attributes.Add("coords", GenerateCoordiantes(t));
        mapPhoto.Controls.Add(gcArea);
    }

    private string GenerateCoordiantes(tTag t)
    {
        return string.Format("{0},{1},{2},{3}", t.nX1, t.nY1, t.nX2, t.nY2);
    }
    #endregion
}

