﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

/// <summary>
/// Summary description for Tags
/// </summary>
public class Tags
{
    public static List<tTag> GetTaggedFriends(int nPhotoId)
    {
        List<tTag> lstTags = new List<tTag>();
        using (DALDataContext con = new DALDataContext())
        {
            var Friends = from t in con.tTags
                          where t.nPhotoId == nPhotoId
                          select t;
            lstTags = Friends.ToList<tTag>();
        }
        return lstTags;
    }

    public static void Add(tTag tag)
    {
        using (DALDataContext con = new DALDataContext())
        {
            con.tTags.InsertOnSubmit(tag);
            con.SubmitChanges();
        }
    }

    public static void RemoveTag(int nPhotoId,int nFriendId)
    {
        using (DALDataContext Con = new DALDataContext())
        {
            tTag tag = Con.tTags.SingleOrDefault(t => t.nFriendId == nFriendId && t.nPhotoId == nPhotoId);
            if (tag != null)
            {
                Con.tTags.DeleteOnSubmit(tag);
                Con.SubmitChanges();
            }
        }
    }
}