using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Xml;
using System.IO;


public partial class History : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        string sFilePath = Server.MapPath("ScoreList.xml");
        XmlDocument doc = new XmlDocument();
        if (File.Exists(sFilePath))
        {
            doc.Load(sFilePath);
            XmlNodeList oScoreList = doc.SelectNodes("//ScoreList/Score");
            if (oScoreList.Count > 0)
            {
                SortedList oList = new SortedList();
                for (int i = 0; i < oScoreList.Count; i++)
                {
                    string sKey = Convert.ToInt32(oScoreList[i].SelectSingleNode(".//Value").InnerText).ToString("0000000") + ":" + i.ToString("00000");
                    oList.Add(sKey, oScoreList[i]);
                }
                HtmlTableRow oRow = null;
                HtmlTableCell oCell = null;
                for (int i = 0; i < oList.Count; i++)
                {
                    if (i < 30)
                    {
                        XmlNode oScore = (XmlNode)oList.GetByIndex(oList.Count - i - 1);
                        oRow = new HtmlTableRow();
                        ScoreTable.Rows.Add(oRow);
                        oCell = new HtmlTableCell();
                        oCell.Align = "Left";
                        oRow.Cells.Add(oCell);
                        oCell.InnerText = Convert.ToInt32(oScore.SelectSingleNode(".//Value").InnerText).ToString("0000000");
                        oCell = new HtmlTableCell();
                        oCell.Align = "Left";
                        oRow.Cells.Add(oCell);
                        oCell.InnerText = oScore.SelectSingleNode(".//Name").InnerText;
                        oCell = new HtmlTableCell();
                        oCell.Align = "Left";
                        oRow.Cells.Add(oCell);
                        oCell.InnerText = Convert.ToDateTime(oScore.SelectSingleNode(".//EndTime").InnerText).ToString("MM/dd/yyyy, HH:mm:ss");
                    }
                }
            }
        }
    }
}
