using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections;
using System.Xml;
using System.IO;

public class Point
{
    public int m_x = 0;
    public int m_y = 0;
    public Point(int x, int y)
    {
        m_x = x;
        m_y = y;
    }
}

public partial class _Default : System.Web.UI.Page 
{
    protected static int m_nRows = ConfigurationManager.AppSettings["Rows"] == null ? 12 : Convert.ToInt32(ConfigurationManager.AppSettings["Rows"]);
    protected static int m_nCols = ConfigurationManager.AppSettings["Cols"] == null ? 11 : Convert.ToInt32(ConfigurationManager.AppSettings["Cols"]);
    protected static int m_nWidth = ConfigurationManager.AppSettings["Width"] == null ? 330 : Convert.ToInt32(ConfigurationManager.AppSettings["Width"]);
    protected static int m_nHeight = ConfigurationManager.AppSettings["Height"] == null ? 360 : Convert.ToInt32(ConfigurationManager.AppSettings["Height"]);
    protected static readonly string m_sXML = "<?xml version=\"1.0\" encoding=\"utf-8\"?><ScoreList></ScoreList>";
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (IsPostBack == false)
        {
            // start new game
            UserInfo.Visible = false;
            bool bNewGame = Request.QueryString["newgame"] == null ? false : Convert.ToBoolean(Request.QueryString["newgame"]);
            if (bNewGame)
            {
                Session["Moves"] = null;
                Response.Redirect("Default.aspx");
            }
            // undo previous move
            Stack oMoves = Session["Moves"] == null ? (new Stack()) : ((Stack)Session["Moves"]);
            Stack oScores = Session["Scores"] == null ? (new Stack()) : ((Stack)Session["Scores"]);
            bool bUndo = Request.QueryString["undo"] == null ? false : Convert.ToBoolean(Request.QueryString["undo"]);
            if (bUndo)
            {
                if (oMoves.Count > 0)
                {
                    oMoves.Pop();
                    Session["Moves"] = oMoves;
                    if (oScores.Count > 0)
                    {
                        oScores.Pop();
                        Session["Scores"] = oScores;
                    }
                    Session["Score"] = oScores.Count == 0 ? 0 : ((int)oScores.Peek());
                }
                Response.Redirect("Default.aspx");
            }
            // make a new move
            object[] pData = oMoves.Count == 0 ? null : ((object[])oMoves.Pop());
            if (pData != null)
            {
                int x = Request.QueryString["x"] == null ? (-1) : Convert.ToInt32(Request.QueryString["x"]);
                int y = Request.QueryString["y"] == null ? (-1) : Convert.ToInt32(Request.QueryString["y"]);
                Point oSource = new Point(x, y);
                if (oSource.m_x >= 0 && oSource.m_x < m_nRows && oSource.m_y >= 0 && oSource.m_y < m_nCols)
                {
                    int nPointScore = GetPointScore(oSource, pData);
                    int nColor = ((int[])pData[oSource.m_x])[oSource.m_y];
                    if (nPointScore > 0 && nColor > 0)
                    {
                        int nScore = Session["Score"] == null ? 0 : Convert.ToInt32(Session["Score"]);
                        nScore += nPointScore;
                        Session["Score"] = nScore;
                        object[] pNewData = CopyData(pData);
                        ((int[])pNewData[oSource.m_x])[oSource.m_y] = 0;
                        for (int i = 0; i < m_nRows; i++)
                        {
                            for (int j = 0; j < m_nCols; j++)
                            {
                                Point oTarget = new Point(i, j);
                                if (IsConnected(oSource, oTarget, pData))
                                {
                                    ((int[])pNewData[oTarget.m_x])[oTarget.m_y] = 0;
                                }
                            }
                        }
                        for (int j = m_nCols-1; j >= 0; j--)
                        {
                            for (int i = m_nRows - 1; i >= 0; i--)
                            {
                            
                                Point oPoint = new Point(i, j);
                                int nPointColor = ((int[])pNewData[i])[j];
                                if (nPointColor == 0)
                                {
                                    for (int k = i - 1; k >= 0; k--)
                                    {
                                        int nNewColor = ((int[])pNewData[k])[j];
                                        if (nNewColor > 0)
                                        {
                                            ((int[])pNewData[i])[j] = nNewColor;
                                            ((int[])pNewData[k])[j] = 0;
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                        for (int j = m_nCols - 1; j >= 0; j--)
                        {
                            int nColorSum = 0;
                            for (int i = m_nRows - 1; i >= 0; i--) nColorSum += ((int[])pNewData[i])[j];
                            if (nColorSum == 0)
                            {
                                for (int k = j - 1; k >= 0; k--)
                                {
                                    int nNewColorSum = 0;
                                    for (int i = m_nRows - 1; i >= 0; i--) nNewColorSum += ((int[])pNewData[i])[k];
                                    if (nNewColorSum > 0)
                                    {
                                        for (int i = m_nRows - 1; i >= 0; i--)
                                        {
                                            ((int[])pNewData[i])[j] = ((int[])pNewData[i])[k];
                                            ((int[])pNewData[i])[k] = 0;
                                        }
                                        break;
                                    }
                                }
                            }
                        }
                        oMoves.Push(pData);
                        oMoves.Push(pNewData);
                        Session["Moves"] = oMoves;
                        oScores.Push(nScore);
                        Session["Scores"] = oScores;
                        Response.Redirect("Default.aspx");
                    }
                }
            }
            // initialize screen for new game
            if (pData == null)
            {
                pData = new object[m_nRows];
                for (int i = 0; i < m_nRows; i++) pData[i] = new int[m_nCols];
                Random oRand = new Random();
                for (int i = 0; i < m_nRows; i++)
                {
                    for (int j = 0; j < m_nCols; j++)
                    {
                        ((int[])pData[i])[j] = oRand.Next(1, 6);
                    }
                }
                Session["Started"] = DateTime.Now;
                Session["Score"] = 0;
            }
            // display screen and current score
            oMoves.Push(pData);
            Session["Moves"] = oMoves;
            DisplayTable(pData);
            Score.InnerText = Session["Score"] == null ? "0" : Convert.ToString(Session["Score"]);
        }
    }

    protected object[] CopyData(object[] pData)
    {
        object[] pNewData = new object[m_nRows];
        for (int i = 0; i < m_nRows; i++)
        {
            pNewData[i] = new int[m_nCols];
            for (int j = 0; j < m_nCols; j++) ((int[])pNewData[i])[j] = ((int[])pData[i])[j];
        }
        return pNewData;
    }

    protected void DisplayTable(object[] pData)
    {
        CalculateScores(pData);
        if (BreakerTable.Visible)
        {
            HtmlTableRow oRow = null;
            HtmlTableCell oCell = null;
            BreakerTable.Rows.Clear();
            BreakerTable.Width = m_nWidth.ToString() + "px";
            BreakerTable.Height = m_nHeight.ToString() + "px";
            for (int i = 0; i < m_nRows; i++)
            {
                oRow = new HtmlTableRow();
                oRow.Height = (m_nHeight / m_nRows).ToString() + "px";
                BreakerTable.Rows.Add(oRow);
                for (int j = 0; j < m_nCols; j++)
                {
                    oCell = new HtmlTableCell();
                    oCell.Width = (m_nWidth / m_nCols).ToString() + "px";
                    oRow.Cells.Add(oCell);
                    oCell.Align = "center";
                    oCell.VAlign = "top";
                    string sScoreKey = "Score:" + i.ToString("00") + "," + j.ToString("00");
                    int nScore = Convert.ToInt32(Session[sScoreKey]);
                    if (nScore > 0)
                        oCell.InnerHtml = "<a href=\"Default.aspx?x=" + i.ToString() + "&y=" + j.ToString() + "\"><img src=\"images/dot" + ((int[])pData[i])[j].ToString("00") + ".png\" border=\"0\" title=\"Score Points: " + nScore.ToString() + "\" /></a>";
                    else
                        oCell.InnerHtml = "<img src=\"images/dot" + ((int[])pData[i])[j].ToString("00") + ".png\" border=\"0\" />";
                }
            }
        }
    }

    protected void ClearScores()
    {
        for (int i = 0; i < m_nRows; i++)
        {
            for (int j = 0; j < m_nCols; j++)
            {
                string sScoreKey = "Score:" + i.ToString("00") + "," + j.ToString("00");
                Session[sScoreKey] = null;
            }
        }
    }

    protected void CalculateScores(object[] pData)
    {
        ClearScores();
        bool bGameOver = true;
        for (int i = 0; i < m_nRows; i++)
        {
            for (int j = 0; j < m_nCols; j++)
            {
                Point oSource = new Point(i, j);
                string sScoreKey = "Score:" + i.ToString("00") + "," + j.ToString("00");
                if (Session[sScoreKey] == null)
                {
                    ArrayList oConnectedSet = new ArrayList();
                    oConnectedSet.Add(oSource);
                    int nCount = 0;
                    for (int m = 0; m < m_nRows; m++)
                    {
                        for (int n = 0; n < m_nCols; n++)
                        {
                            Point oTarget = new Point(m, n);
                            if (IsConnected(oSource, oTarget, pData))
                            {
                                nCount++;
                                oConnectedSet.Add(oTarget);
                            }
                        }
                    }
                    if (nCount > 0)
                    {
                        bGameOver = false;
                        int nScore = 1;
                        int nCount2 = nCount > 9 ? 9 : nCount;
                        for (int k = 0; k < nCount2; k++) nScore *= 2;
                        for (int k = nCount2; k < nCount; k++) nScore += 64;
                        for (int k = 0; k < oConnectedSet.Count; k++)
                        {
                            Point oPoint = (Point)oConnectedSet[k];
                            string sPointScoreKey = "Score:" + oPoint.m_x.ToString("00") + "," + oPoint.m_y.ToString("00");
                            Session[sPointScoreKey] = nScore;
                        }
                    }
                    else Session[sScoreKey] = 0;
                }
            }
        }
        if (bGameOver)
        {
            bool bColor1 = false;
            bool bColor2 = false;
            bool bColor3 = false;
            bool bColor4 = false;
            bool bColor5 = false;  
            for (int i = 0; i < m_nRows; i++)
            {
                for (int j = 0; j < m_nCols; j++)
                {
                    if(((int[])pData[i])[j]==1) bColor1 = true;
                    if(((int[])pData[i])[j]==2) bColor2 = true;
                    if(((int[])pData[i])[j]==3) bColor3 = true;
                    if(((int[])pData[i])[j]==4) bColor4 = true;
                    if(((int[])pData[i])[j]==5) bColor5 = true;    
                }
            }
            int nBonus = (bColor1 ? 0 : 1) + (bColor2 ? 0 : 1) + (bColor3 ? 0 : 1) + (bColor4 ? 0 : 1) + (bColor5 ? 0 : 1);
            if (nBonus > 0)
            {
                int nScore = (Session["Score"] == null ? 0 : Convert.ToInt32(Session["Score"]));
                nScore = nScore * (5 + nBonus) / 5;
                Session["Score"] = nScore;
            }
            BreakerTable.Visible = false;
            UserInfo.Visible = true;
        }
    }

    protected int GetPointScore(Point oPoint, object[] pData)
    {
        string sScoreKey = "Score:" + oPoint.m_x.ToString("00") + "," + oPoint.m_y.ToString("00");
        return (Session[sScoreKey] == null) ? 0 : Convert.ToInt32(Session[sScoreKey]);
    }

    protected bool IsConnected(Point oSource, Point oTarget, object[] pData)
    {
        if (oSource.m_x == oTarget.m_x && oSource.m_y == oTarget.m_y || oSource.m_x < 0 || oSource.m_x >= m_nRows || oSource.m_y < 0 || oSource.m_y >= m_nCols || oTarget.m_x < 0 || oTarget.m_x >= m_nRows || oTarget.m_y < 0 || oTarget.m_y >= m_nCols) 
        {
            return false;
        }
        if (oSource.m_x == oTarget.m_x && System.Math.Abs(oSource.m_y - oTarget.m_y) == 1 || System.Math.Abs(oSource.m_x - oTarget.m_x) == 1 && oSource.m_y == oTarget.m_y)
        {
            int nSourceColor = ((int[])pData[oSource.m_x])[oSource.m_y];
            int nTargetColor = ((int[])pData[oTarget.m_x])[oTarget.m_y];
            bool bSameColor = (nSourceColor == nTargetColor && nSourceColor > 0);
            return bSameColor;
        }
        string sVisitedKey = "Visited:" + oSource.m_x.ToString("00") + "," + oSource.m_y.ToString("00") + ";" + oTarget.m_x.ToString("00") + "," + oTarget.m_y.ToString("00"); 
        if (Session[sVisitedKey] != null) return false;
        Session[sVisitedKey] = true;
        Point oRight = new Point(oSource.m_x + 1, oSource.m_y);
        Point oLeft = new Point(oSource.m_x - 1, oSource.m_y);
        Point oUpper = new Point(oSource.m_x, oSource.m_y + 1);
        Point oLower = new Point(oSource.m_x, oSource.m_y - 1);
        bool bRet =
            IsConnected(oSource, oRight, pData) && IsConnected(oRight, oTarget, pData) ||
            IsConnected(oSource, oLeft, pData) && IsConnected(oLeft, oTarget, pData) ||
            IsConnected(oSource, oUpper, pData) && IsConnected(oUpper, oTarget, pData) ||
            IsConnected(oSource, oLower, pData) && IsConnected(oLower, oTarget, pData);
        Session[sVisitedKey] = null;
        return bRet;
    }

    protected void Submit_Click(object sender, EventArgs e)
    {
        UserName.Text = UserName.Text.Trim().ToUpper();
        lock (typeof(_Default))
        {
            try
            {
                string sFilePath = Server.MapPath("ScoreList.xml");
                XmlDocument doc = new XmlDocument();
                if (File.Exists(sFilePath)) doc.Load(sFilePath);
                else doc.LoadXml(m_sXML);
                XmlNode oListNode = doc.SelectSingleNode("//ScoreList");
                XmlNode oScore = doc.CreateElement("Score");
                oListNode.AppendChild(oScore);
                XmlNode oName = doc.CreateElement("Name");
                oScore.AppendChild(oName);
                oName.InnerText = UserName.Text == "" ? "ANONYMOUS" : UserName.Text;
                XmlNode oStart = doc.CreateElement("StartTime");
                oScore.AppendChild(oStart);
                oStart.InnerText = Convert.ToDateTime(Session["Started"]).ToString();
                XmlNode oEnd = doc.CreateElement("EndTime");
                oScore.AppendChild(oEnd);
                oEnd.InnerText = DateTime.Now.ToString();
                XmlNode oValue = doc.CreateElement("Value");
                oScore.AppendChild(oValue);
                oValue.InnerText = Score.InnerText;
                XmlNode oIP = doc.CreateElement("IP");
                oScore.AppendChild(oIP);
                oIP.InnerText = Request.UserHostAddress;
                doc.Save(sFilePath);
            }
            catch (Exception) { }
        }
        Session["Moves"] = null;
        Response.Redirect("Default.aspx");
    }
}
