﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Services;
using System.Web.UI.DataVisualization.Charting;
using System.IO;

namespace WebSamples
{
   /// <summary>
   /// Summary description for SampleWebService
   /// </summary>
   [WebService(Namespace = "http://tempuri.org/")]
   [WebServiceBinding(ConformsTo = WsiProfiles.BasicProfile1_1)]
   [System.ComponentModel.ToolboxItem(false)]
   [System.Web.Script.Services.ScriptService]
   public class SampleWebService : System.Web.Services.WebService
   {

      [WebMethod]
      public string HelloWorld()
      {
         return "Hello World";
      }


      /// <summary>
      /// Create a chart image and return image file name
      /// </summary>
      /// 
      ///<param name="iType"> 
      ///Type of the chart to draw: 1=Sin(x) 2=Cos(x) 3=Tan(x)
      ///</param>
      [WebMethod]
      public String DrawChart(Int32 iType){

         //class that creates the Chart object
         RuntimeChart runChart = new RuntimeChart();
         Chart m_chart = runChart.makeChart(iType);

         String tempFileName = String.Format("TempChartImage/Chart_{0}.png", System.Guid.NewGuid().ToString());

         tempFileName = Context.Server.MapPath(tempFileName);

         m_chart.SaveImage(tempFileName);
         String strImageSrc = @"TempChartImage/" + Path.GetFileName(tempFileName);

         // set callback when item was removed from cache
         ChartImageDestructor cid = new ChartImageDestructor(tempFileName);
         System.Web.Caching.CacheItemRemovedCallback onRemove = new System.Web.Caching.CacheItemRemovedCallback(cid.RemovedCallback);


         //insert filename into cache
         HttpContext.Current.Cache.Add(tempFileName, cid, null,
               DateTime.Now.AddMinutes(10),
               System.Web.Caching.Cache.NoSlidingExpiration,
               System.Web.Caching.CacheItemPriority.NotRemovable,
               onRemove);

         return strImageSrc;
      }
   }
}
