﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="WebSamples._Default" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <script type="text/javascript" src="Script/jquery-1.3.2.min.js"></script>
    <script type="text/javascript" src="Script/jquery.json-1.3.min.js"></script>
</head>
<body>
    <form id="form1" runat="server">
    <script type="text/javascript">
       //retrive the URL of the WebService
       var WebServiceURL = "<%=Request.Url.GetLeftPart(UriPartial.Authority)+Request.ApplicationPath.ToString() %>/SampleWebService.asmx";

       //when DOM is ready...
       $(function() {
          
          //intercept the onchange event fire by element with "graphType" ID (SELECT)
          $("#graphType").change(function() {
             //get the attribute "value" of the OPTION element selected and pass it as parameter
             getChartImage($("option:selected", this).attr("value"));
          });
       });

       function getChartImage(type) {
          if (type < 0)
             return;

          //create the object for passing data to Web Service
          var dataPassed = new Object();
          dataPassed.iType = type;

          //call a Web service with jQuery
          $.ajax({
             type: "POST",
             contentType: "application/json; charset=utf-8",
             url: WebServiceURL + "/DrawChart",
             data: $.toJSON(dataPassed),
             success:
                  function(msg) {
                     var data = $.evalJSON(msg).d;
                     //set the "src" attribute of image
                     $("#ChartArea").attr("src", data);
                  },
             error:
                  function(XMLHttpRequest, textStatus, errorThrown) {
                     alert(XMLHttpRequest.responseText);
                  }
          });
       }
    </script>
    <div>
      <table>
      <tr>
      <td>
          <img id="ChartArea" />
       </td>
       <td>
          <select id="graphType">
             <option value="-1">Select type...</option>
             <option value="1">Sin (X)</option>
             <option value="2">Cos (X)</option>
             <option value="3">Tan (X)</option>
          </select>
       </td>
       </tr>
       </table>
       </div>
    </form>
</body>
</html>
