﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Web.UI.DataVisualization.Charting;
using System.Web.UI.WebControls;
using System.Drawing;
using System.Collections;
using System.Data;

namespace WebSamples
{
   public class RuntimeChart{
      private Chart m_chart;

      public RuntimeChart() {
         m_chart = new Chart();
      }

      public Chart makeChart(Int32 iType){
         //Chart setting 
         m_chart.Height = Unit.Pixel(200);
         m_chart.Width = Unit.Pixel(400);
         m_chart.BorderlineColor = Color.Black;
         m_chart.BorderlineDashStyle = ChartDashStyle.Solid;
         m_chart.BorderlineWidth = 2;
         m_chart.BorderSkin.SkinStyle = BorderSkinStyle.Emboss;


         //Chart Area
         ChartArea mainArea = new ChartArea();
         mainArea.Name = "mainArea";
         mainArea.BackColor = Color.FromArgb(255, 255, 192);
         mainArea.BackGradientStyle = GradientStyle.TopBottom;
         mainArea.BorderDashStyle = ChartDashStyle.Solid;
         m_chart.ChartAreas.Add(mainArea);

         //Legend
         Legend mainLegend = new Legend();
         mainLegend.Name = "mainLegend";
         mainLegend.DockedToChartArea = "mainArea";
         mainLegend.Docking = Docking.Top;
         mainLegend.HeaderSeparator = LegendSeparatorStyle.Line;
         mainLegend.IsDockedInsideChartArea = false;
         m_chart.Legends.Add(mainLegend);

         Series sr = new Series();
         sr.ChartArea = "mainArea";
         sr.Legend = "mainLegend";
         sr.ChartType = SeriesChartType.Spline;
         sr.Name = "Series1";

         //generate some point for the chart
         for (Int32 i = 0; i < 10; i++)
         {
            Double x = (Double)i;

            //value of the y depend on parameter iType
            switch (iType) {
               case 1: {
                  sr.Points.AddXY(x, Math.Sin(x));
               } break;
               case 2:{
                  sr.Points.AddXY(x, Math.Cos(x));
                  } break;
               case 3:{
                  sr.Points.AddXY(x, Math.Tan(x));
                  } break;
            }
            
         }
         m_chart.Series.Add(sr);

         return m_chart;
      }
   }
}
