using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;

public partial class Flash : System.Web.UI.Page
{
    //Total No of ads to display
    static int TotalAds = 5;

    /// <summary>
    /// Initial/First ad to display
    /// </summary>
    int _adCount = 1;
    public int AdCount
    {
        get { return _adCount; }
        set { _adCount = value; }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
           PrevBtn.Enabled = false;
           FlashAdRotator1.DataSource = GetAds(AdCount);
           FlashAdRotator1.DataBind();
           
        }
    }
    /// <summary>
    /// Fetch ads from database
    /// </summary>
    /// <param name="Count"></param>
    /// <returns></returns>
    private DataTable GetAds(int AdNo) 
    {
       string sql = "select AlternateText,ImageUrl,NavigateUrl from AdsDataTable where OrderId = " + AdNo.ToString(); 
       SqlConnection con = new SqlConnection(ConfigurationManager.ConnectionStrings["AdsConnectionString"].ToString());
       SqlDataAdapter adsa = new SqlDataAdapter(sql, con);
       DataTable AdsTable = new DataTable(); 
       adsa.Fill(AdsTable); 
       return AdsTable; 
    }
   
    //UpdatePanel1.Update(); 
    protected void NextBtn_Click(object sender, ImageClickEventArgs e)
    {
        if (ViewState["Count"] != null)
            AdCount = (int)ViewState["Count"];
        AdCount = AdCount + 1;
        ViewState["Count"] = AdCount;
        NextBtn.Enabled = AdCount == TotalAds ? false : true;
        PrevBtn.Enabled = AdCount >= 1 ? true : false;
        FlashAdRotator1.DataSource = GetAds(AdCount);
        FlashAdRotator1.DataBind();
    }

    protected void PrevBtn_Click(object sender, ImageClickEventArgs e)
    {
        if (ViewState["Count"] != null)
            AdCount = (int)ViewState["Count"];
        AdCount = AdCount - 1;
        ViewState["Count"] = AdCount;
        PrevBtn.Enabled = AdCount == 1 ? false : true;
        NextBtn.Enabled = AdCount <= TotalAds ? true : false;
        FlashAdRotator1.DataSource = GetAds(AdCount);
        FlashAdRotator1.DataBind();
    }
}
