using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Web;
using System.Web.SessionState;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.HtmlControls;

using System.Drawing.Text;
using System.Data.OleDb;  // For the Access db.

namespace DynamicTextImage
{
	/// <summary>
	/// Summary description for WebForm1.
	/// </summary>
	public class WebForm1 : System.Web.UI.Page
	{
		protected System.Web.UI.WebControls.TextBox txt_Image;
		protected System.Web.UI.WebControls.Button Button1;
	
		private void Page_Load(object sender, System.EventArgs e)
		{
			// Is this page being loaded for the first time?
			if( IsPostBack ) 
			{
				Response.ContentType = "image/gif";

				// Call the CreateImage() function to save the text entered into the text box to a stream which will be
				// drawn in the CreateImage() function.
				CreateImage( txt_Image.Text ).Save( Response.OutputStream, System.Drawing.Imaging.ImageFormat.Gif );

				Response.End();
			}
			/*else
			{
				Button1_Click( this, null );
			}*/

			Response.Write( "Click in the text box then hit return, you'll now see the new test image created.<br>" );
		}

		private static Bitmap CreateImage( string sImageText ) 
		{
			Bitmap bmpImage = new Bitmap( 1, 1 );

			int iWidth = 0;
			int iHeight = 0;

			//Create a Font object
			Font MyFont = new Font( "Verdana", 24, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point );

			// Create a Graphics Class to measure the text width	
			Graphics MyGraphics = Graphics.FromImage( bmpImage );

			// Resize the bitmap, this is where the bitmap is sized.
			iWidth = (int)MyGraphics.MeasureString( sImageText, MyFont ).Width;
			iHeight = (int)MyGraphics.MeasureString( sImageText, MyFont ).Height;

			// Create the bmpImage again with the correct size for the text and font.
			bmpImage = new Bitmap( bmpImage, new Size( iWidth, iHeight ) );

			// Apply the colors and draw the bitmap.
			MyGraphics = Graphics.FromImage( bmpImage );
			MyGraphics.Clear( Color.Navy );
			MyGraphics.TextRenderingHint = TextRenderingHint.AntiAlias;
			MyGraphics.DrawString( sImageText, MyFont, new SolidBrush( Color.Red ), 0, 0 );
			MyGraphics.Flush();

			return( bmpImage );
		}

		#region Web Form Designer generated code
		override protected void OnInit(EventArgs e)
		{
			//
			// CODEGEN: This call is required by the ASP.NET Web Form Designer.
			//
			InitializeComponent();
			base.OnInit(e);
		}
		
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{    
			this.Button1.Click += new System.EventHandler(this.Button1_Click);
			this.Load += new System.EventHandler(this.Page_Load);

		}
		#endregion

		private void Button1_Click(object sender, System.EventArgs e)
		{
			string sContactName = "";

			OleDbConnection OledbConn = new OleDbConnection( @"Provider=Microsoft.Jet.OLEDB.4.0;Data Source=c:\Inetpub\wwwroot\DynamicTextImage\Northwind.mdb" );

			OledbConn.Open();
    
			// Execute a select statement to retrieve data.
			OleDbCommand cmd = OledbConn.CreateCommand();
			cmd.CommandText = "SELECT ContactName FROM Customers WHERE CustomerID = ALFKI";

			OleDbDataReader dr = cmd.ExecuteReader();

			while( dr.Read() )
			{
				sContactName = (string)dr["ContactName"];
			}

			if( sContactName != "" )
			{
				CreateImage( sContactName );
			}

			// Close the connection
			dr.Close();
			OledbConn.Close();
		}
	}
}
