<%@ Page Language="VB" %>
<script language="VB" runat="server">

	Sub Page_Load(sender As Object, e As EventArgs)
		' Static Chart (with Bar Labels)
		Dim arrValues1() As Integer = {6, 10, 12, 18, 23, 26, 27, 28, 30, 34, 37, 45, 55}
		Dim arrLabels1() As String  = {"P1", "P2", "P3", "P4", "P5", "P6", "P7", "P8", "P9", "P10", "P11", "P12", "P13"}

		myFirstChart.Text = BuildChartHTML(arrValues1, arrLabels1, "Chart Title", "X Label", "Y Label")


		' Chart made from random numbers (without Bar Labels)
		Dim arrValues2(49) As Integer
		Dim I              As Integer

		Randomize
		For I = 0 to 49
			arrValues2(I) = Int((50 + 1) * Rnd)
		Next I

		mySecondChart.Text = BuildChartHTML(arrValues2, "Note that this isn't an Array!", "Chart of 50 Random Numbers", "Index", "Value")
	End Sub


	Function BuildChartHTML(ByRef aValues, ByRef aLabels, ByRef strTitle, ByRef strXAxisLabel, ByRef strYAxisLabel)
		' Some user changable graph defining constants.  All units are in screen pixels
		Const GRAPH_WIDTH  As Integer = 450  ' The width of the body of the graph
		Const GRAPH_HEIGHT As Integer = 250  ' The heigth of the body of the graph
		Const GRAPH_BORDER As Integer = 5    ' The size of the black border
		Const GRAPH_SPACER As Integer = 2    ' The size of the space between the bars

		' Debugging constant so I can eaasily switch on borders in case
		' the tables get messed up.  Should be left at zero unless you're
		' trying to figure out which table cell is doing what.
		Const TABLE_BORDER As Integer = 0
		'Const TABLE_BORDER = 10

		' Declare our variables
		Dim I          As Integer
		Dim iMaxValue  As Integer
		Dim iBarWidth  As Integer
		Dim iBarHeight As Integer
		Dim myStringBuilder As StringBuilder

		' Get the maximum value in the data set
		iMaxValue = 0
		For I = 0 To UBound(aValues)
			If iMaxValue < aValues(I) Then iMaxValue = aValues(I)
		Next I
		'Response.Write iMaxValue ' Debugging line


		' Calculate the width of the bars
		' Take the overall width and divide by number of items and round down.
		' I then reduce it by the size of the spacer so the end result
		' should be GRAPH_WIDTH or less!
		iBarWidth = (GRAPH_WIDTH \ (UBound(aValues) + 1)) - GRAPH_SPACER
		'Response.Write iBarWidth ' Debugging line

		' Start building the graph's HTML
		myStringBuilder = New StringBuilder()

		myStringBuilder.Append("<TABLE BORDER=""" & TABLE_BORDER & """ CELLSPACING=""0"" CELLPADDING=""0""> " & vbCrLf)
		myStringBuilder.Append("<TR><TD COLSPAN=""3"" ALIGN=""center""><H2>" & strTitle & "</H2></TD></TR> " & vbCrLf)
		myStringBuilder.Append("<TR> " & vbCrLf)
		myStringBuilder.Append("    <TD VALIGN=""center""><B>" & strYAxisLabel & "</B></TD> " & vbCrLf)
		myStringBuilder.Append("    <TD VALIGN=""top""> " & vbCrLf)
		myStringBuilder.Append("      <TABLE BORDER=""" & TABLE_BORDER & """ CELLSPACING=""0"" CELLPADDING=""0""> " & vbCrLf)
		myStringBuilder.Append("        <TR> " & vbCrLf)
		myStringBuilder.Append("          <TD ROWSPAN=""2""><IMG SRC=""images/spacer.gif"" BORDER=""0"" WIDTH=""1"" HEIGHT=""" & GRAPH_HEIGHT & """></TD> " & vbCrLf)
		myStringBuilder.Append("          <TD VALIGN=""top"" ALIGN=""right"">" & iMaxValue & "&nbsp;</TD> " & vbCrLf)
		myStringBuilder.Append("        </TR> " & vbCrLf)
		myStringBuilder.Append("        <TR> " & vbCrLf)
		myStringBuilder.Append("          <TD VALIGN=""bottom"" ALIGN=""right"">0&nbsp;</TD> " & vbCrLf)
		myStringBuilder.Append("        </TR> " & vbCrLf)
		myStringBuilder.Append("      </TABLE> " & vbCrLf)
		myStringBuilder.Append("    </TD> " & vbCrLf)
		myStringBuilder.Append("    <TD> " & vbCrLf)

		myStringBuilder.Append("      <TABLE BORDER=""" & TABLE_BORDER & """ CELLSPACING=""0"" CELLPADDING=""0""> " & vbCrLf)
		myStringBuilder.Append("        <TR> " & vbCrLf)
		myStringBuilder.Append("          <TD VALIGN=""bottom""><IMG SRC=""images/spacer_black.gif"" BORDER=""0"" WIDTH=""" & GRAPH_BORDER & """ HEIGHT=""" & GRAPH_HEIGHT & """></TD> " & vbCrLf)

		' We're now in the body of the chart.  Loop through the data showing the bars!
		For I = 0 To UBound(aValues)
			iBarHeight = Int((aValues(I) / iMaxValue) * GRAPH_HEIGHT)
		
			' This is a hack since browsers ignore a 0 as an image dimension!
			If iBarHeight = 0 Then iBarHeight = 1
			myStringBuilder.Append("          <TD VALIGN=""bottom""><IMG SRC=""images/spacer.gif"" BORDER=""0"" WIDTH=""" & GRAPH_SPACER & """ HEIGHT=""1""></TD> " & vbCrLf)
			myStringBuilder.Append("          <TD VALIGN=""bottom""><IMG SRC=""images/spacer_red.gif"" BORDER=""0"" WIDTH=""" & iBarWidth & """ HEIGHT=""" & iBarHeight & """ ALT=""" & aValues(I) & """></TD> " & vbCrLf)
		Next I
		myStringBuilder.Append("        </TR> " & vbCrLf)

		' I was using GRAPH_BORDER + GRAPH_WIDTH but it was moving the last x axis label
		myStringBuilder.Append("        <TR> " & vbCrLf)
		myStringBuilder.Append("          <TD COLSPAN=""" & (2 * (UBound(aValues) + 1)) + 1 & """><IMG SRC=""images/spacer_black.gif"" BORDER=""0"" WIDTH=""" & GRAPH_BORDER + ((UBound(aValues) + 1) * (iBarWidth + GRAPH_SPACER)) & """ HEIGHT=""" & GRAPH_BORDER & """></TD> " & vbCrLf)
		myStringBuilder.Append("        </TR> " & vbCrLf)

		' The label array is optional and is really only useful for small data sets with very short labels!
		If IsArray(aLabels) Then
			myStringBuilder.Append("        <TR> " & vbCrLf)
			myStringBuilder.Append("          <TD><!-- Spacing for Left Border Column --></TD> " & vbCrLf)
			For I = 0 To UBound(aValues)
				myStringBuilder.Append("          <TD><!-- Spacing for Spacer Column --></TD> " & vbCrLf)
				myStringBuilder.Append("          <TD ALIGN=""center""><FONT SIZE=""1"">" & aLabels(I) & "</FONT></TD> " & vbCrLf)
			Next I
			myStringBuilder.Append("        </TR> " & vbCrLf)
		End If
		myStringBuilder.Append("      </TABLE> " & vbCrLf)

		myStringBuilder.Append("    </TD> " & vbCrLf)
		myStringBuilder.Append("  </TR> " & vbCrLf)
		myStringBuilder.Append("  <TR> " & vbCrLf)
		myStringBuilder.Append("    <TD COLSPAN=""2""><!-- Place holder for X Axis label centering--></TD> " & vbCrLf)
		myStringBuilder.Append("    <TD ALIGN=""center""><BR><B>" & strXAxisLabel & "</B></TD> " & vbCrLf)
		myStringBuilder.Append("  </TR>")
		myStringBuilder.Append("</TABLE>")

		BuildChartHTML = myStringBuilder.ToString
	End Function

</script>

<html>
<head>
<title>ASP.NET Bar Chart Sample</title>
</head>
<body>

<form runat="server">

<asp:Literal id="myFirstChart" runat="server" />

<br />
<br />
<br />

<asp:Literal id="mySecondChart" runat="server" />

</form>

<hr />

<p>
Click <a href="http://www.asp101.com/samples/bar_chart_aspx.asp">here</a>
to read about and download the source code.
</p>

</body>
</html>
