using System;
using System.Data;
using System.Data.SqlClient;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

public partial class Admin_PhotoManager : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
    }

    private void BindDataList(int albumid)
    {
        SqlParameter[] p = new SqlParameter[1];
        p[0]= new SqlParameter("@albumid", albumid);
        DataList1.DataSource= SqlHelper.ExecuteDataSet("select * from photos where albumid=@albumid",p);
        DataList1.DataKeyField = "PhotoID";
        DataList1.DataBind();
    }


    protected void DataList1_ItemDataBound(object sender, DataListItemEventArgs e)
    {
        Image img = (Image)e.Item.FindControl("Image1");
        if (img != null)
            img.ImageUrl = "~/getphoto.aspx?imgtype=thumbnail&photoid=" + DataList1.DataKeys[e.Item.ItemIndex].ToString();
    }

    protected void DropDownList1_SelectedIndexChanged(object sender, EventArgs e)
    {
        BindDataList(int.Parse(DropDownList1.SelectedValue));
    }
    protected void DropDownList1_DataBound(object sender, EventArgs e)
    {
        BindDataList(int.Parse(DropDownList1.SelectedValue));
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        if (ViewState["mode"].ToString() == "Add")
        {
            Stream imgdatastream = File1.PostedFile.InputStream;
            int imgdatalen = File1.PostedFile.ContentLength;
            byte[] imgdata = new byte[imgdatalen];
            int n = imgdatastream.Read(imgdata, 0, imgdatalen);

            string sql = "INSERT INTO PHOTOS(ALBUMID,NAME,DESCRIPTION,IMAGE,THUMBNAILHEIGHT,THUMBNAILWIDTH) VALUES(@albumid,@name,@desc,@image,@ht,@wt)";
            SqlParameter[] p = new SqlParameter[6];
            p[0] = new SqlParameter("@albumid", DropDownList1.SelectedValue);
            p[1] = new SqlParameter("@name", TextBox1.Text);
            p[2] = new SqlParameter("@desc", TextBox2.Text);
            p[3] = new SqlParameter("@image", imgdata);
            p[4] = new SqlParameter("@ht", TextBox3.Text);
            p[5] = new SqlParameter("@wt", TextBox4.Text);
            SqlHelper.ExecuteNonQuery(sql, p);
            BindDataList(int.Parse(DropDownList1.SelectedValue));
        }

        if (ViewState["mode"].ToString() == "Edit")
        {
            Stream imgdatastream = File1.PostedFile.InputStream;
            int imgdatalen = File1.PostedFile.ContentLength;
            byte[] imgdata = new byte[imgdatalen];
            int n = imgdatastream.Read(imgdata, 0, imgdatalen);

            string sql = "UPDATE PHOTOS SET NAME=@name,DESCRIPTION=@desc,IMAGE=@image,THUMBNAILHEIGHT=@ht,THUMBNAILWIDTH=@wt WHERE PHOTOID=@id";
            SqlParameter[] p = new SqlParameter[6];
            p[0] = new SqlParameter("@name", TextBox1.Text);
            p[1] = new SqlParameter("@desc", TextBox2.Text);
            p[2] = new SqlParameter("@image", imgdata);
            p[3] = new SqlParameter("@ht", TextBox3.Text);
            p[4] = new SqlParameter("@wt", TextBox4.Text);
            p[5] = new SqlParameter("@id",DataList1.DataKeys[DataList1.SelectedIndex]);
            SqlHelper.ExecuteNonQuery(sql, p);
            BindDataList(int.Parse(DropDownList1.SelectedValue));
        }
        Panel1.Visible = false;

    }
    protected void DataList1_ItemCommand(object source, DataListCommandEventArgs e)
    {
        if (e.CommandName == "Edit")
        {
            int photoid=(int)DataList1.DataKeys[e.Item.ItemIndex];
            TextBox1.Text = ((Label)e.Item.FindControl("Label2")).Text;
            TextBox2.Text = ((Label)e.Item.FindControl("Label3")).Text;
            TextBox3.Text = ((Label)e.Item.FindControl("Label10")).Text;
            TextBox4.Text = ((Label)e.Item.FindControl("Label12")).Text;
            ViewState["mode"] = "Edit";
            DataList1.SelectedIndex = e.Item.ItemIndex;
            Panel1.Visible = true;
        }
        if (e.CommandName == "Delete")
        {
            string sql = "delete from photos where photoid=@photoid";
            SqlParameter[] p = new SqlParameter[1];
            p[0] = new SqlParameter("@photoid", DataList1.DataKeys[e.Item.ItemIndex]);
            SqlHelper.ExecuteNonQuery(sql, p);
            BindDataList(int.Parse(DropDownList1.SelectedValue));
        }
    }
    protected void DataList1_SelectedIndexChanged(object sender, EventArgs e)
    {

    }
    protected void LinkButton3_Click(object sender, EventArgs e)
    {
        TextBox1.Text = "";
        TextBox2.Text = "";
        TextBox3.Text = "";
        TextBox4.Text = "";
        DataList1.SelectedIndex = -1;
        ViewState["mode"] = "Add";
        Panel1.Visible = true;
    }
}
