﻿Imports ZedGraph
Imports System.Drawing
Partial Class Default2
    Inherits System.Web.UI.Page
    Protected Sub ZedGraphWeb1_RenderGraph(ByVal zgc As ZedGraph.Web.ZedGraphWeb, _
                  ByVal g As System.Drawing.Graphics, _
                  ByVal masterPane As ZedGraph.MasterPane) Handles ZedGraphWeb1.RenderGraph

        ' GraphPane 
        Dim myPane As GraphPane = masterPane(0)
        ' Impostiamo il titolo e i valori sugli assi
        myPane.Title.Text = "Esempio di Grafico a barre con etichette"
        myPane.XAxis.Title.Text = "Vendite"
        myPane.YAxis.Title.Text = "Anni"

        ' 3 BarItems
        Dim list1 As New PointPairList()
        Dim list2 As New PointPairList()
        Dim list3 As New PointPairList()

        ' utilizziamo valori random
        Dim i As Integer, rand As New Random()
        Dim y As Double, x1 As Double, x2 As Double, x3 As Double
        For i = 1 To 5
            y = i
          
            x1 = 100.0 + rand.NextDouble() * 100.0
            x2 = 100.0 + rand.NextDouble() * 100.0
            x3 = 100.0 + rand.NextDouble() * 100.0

            list1.Add(x1, y)
            list2.Add(x2, y)
            list3.Add(x3, y)
        Next i

        ' creaiamo 3 BarItems, impostiamo il colore e l'angolo a 90 gradi per le barre orizzontali
        Dim bar1 As BarItem = myPane.AddBar("Bar 1", list1, Color.Red)
        bar1.Bar.Fill = New Fill(Color.Red, Color.White, Color.Red, 90)
        Dim bar2 As BarItem = myPane.AddBar("Bar 2", list2, Color.Blue)
        bar2.Bar.Fill = New Fill(Color.Chartreuse, Color.White, Color.Blue, 90)
        Dim bar3 As BarItem = myPane.AddBar("Bar 3", list3, Color.Green)
        bar3.Bar.Fill = New Fill(Color.Gray, Color.White, Color.Green, 90)


        myPane.BarSettings.Base = BarBase.Y
        myPane.BarSettings.Type = BarType.Stack

        ' colore di sfondo del grafico
        myPane.Chart.Fill = New Fill(Color.Beige, _
              Color.FromArgb(255, 255, 166), 45.0F)

        masterPane.AxisChange(g)
        ' creaimo una un TextObj'per mostrare le labels in ogni barra
        BarItem.CreateBarLabels(myPane, True, "f0")

    End Sub
End Class
