﻿Imports ZedGraph
Imports System.Drawing

Public Class _Default
    Inherits System.Web.UI.Page

    Protected Sub ZedGraphWeb1_RenderGraph(ByVal z As ZedGraph.Web.ZedGraphWeb, _
                ByVal g As System.Drawing.Graphics, _
                ByVal masterPane As ZedGraph.MasterPane) Handles ZedGraphWeb1.RenderGraph

        ' Get the GraphPane so we can work with it
        Dim myPane As GraphPane = masterPane(0)

        ' Set the title and axis labels
        myPane.Title.Text = "Cat Stats"
        myPane.YAxis.Title.Text = "Big Cats"
        myPane.XAxis.Title.Text = "Population"

        ' Make up some data points
        Dim labels() As String = {"Panther", "Lion", "Cheetah", "Cougar", "Tiger", "Leopard"}
        Dim x() As Double = {100, 115, 75, 22, 98, 40}
        Dim x2() As Double = {120, 175, 95, 57, 113, 110}
        Dim x3() As Double = {204, 192, 119, 80, 134, 156}

        ' Generate a red bar with "Curve 1" in the legend
        Dim myCurve As BarItem = myPane.AddBar("Here", x, Nothing, Color.Red)
        ' Fill the bar with a red-white-red color gradient for a 3d look
        myCurve.Bar.Fill = New Fill(Color.Red, Color.White, Color.Red, 90.0F)

        ' Generate a blue bar with "Curve 2" in the legend
        myCurve = myPane.AddBar("There", x2, Nothing, Color.Blue)
        ' Fill the bar with a Blue-white-Blue color gradient for a 3d look
        myCurve.Bar.Fill = New Fill(Color.Blue, Color.White, Color.Blue, 90.0F)

        ' Generate a green bar with "Curve 3" in the legend
        myCurve = myPane.AddBar("Elsewhere", x3, Nothing, Color.Green)
        ' Fill the bar with a Green-white-Green color gradient for a 3d look
        myCurve.Bar.Fill = New Fill(Color.Green, Color.White, Color.Green, 90.0F)

        ' Draw the Y tics between the labels instead of at the labels
        myPane.YAxis.MajorTic.IsBetweenLabels = True

        ' Set the YAxis labels
        myPane.YAxis.Scale.TextLabels = labels
        ' Set the YAxis to Text type
        myPane.YAxis.Type = AxisType.Text

        ' Set the bar type to stack, which stacks the bars by automatically accumulating the values
        myPane.BarSettings.Type = BarType.Stack

        ' Make the bars horizontal by setting the BarBase to "Y"
        myPane.BarSettings.Base = BarBase.Y

        ' Fill the axis background with a color gradient
        myPane.Chart.Fill = New Fill(Color.White, _
            Color.FromArgb(255, 255, 166), 45.0F)

        masterPane.AxisChange(g)
    End Sub

    Protected Sub ZedGraphWeb2_RenderGraph(ByVal z As ZedGraph.Web.ZedGraphWeb, _
                ByVal g As System.Drawing.Graphics, _
                ByVal masterPane As ZedGraph.MasterPane) Handles ZedGraphWeb2.RenderGraph

        ' Get the GraphPane so we can work with it
        Dim myPane As GraphPane = masterPane(0)

        ' Set the titles and axis labels
        myPane.Title.Text = "My Test Date Graph"
        myPane.XAxis.Title.Text = "Date"
        myPane.YAxis.Title.Text = "My Y Axis"

        ' Make up some data points from the Sine function
        Dim list As New PointPairList()
        Dim list2 As New PointPairList()

        Dim i As Integer, x As Double, y As Double, y2 As Double
        For i = 0 To 35
            x = New XDate(1995, i + 1, 1)
            y = Math.Sin(i * Math.PI / 15.0)
            y2 = 2 * y

            list.Add(x, y)
            list2.Add(x, y2)
        Next i

        ' Generate a blue curve with circle symbols, and "My Curve 2" in the legend
        Dim myCurve2 As LineItem = myPane.AddCurve("My Curve 2", list, Color.Blue, _
                                SymbolType.Circle)
        ' Fill the area under the curve with a white-red gradient at 45 degrees
        myCurve2.Line.Fill = New Fill(Color.White, Color.Red, 45.0F)
        ' Make the symbols opaque by filling them with white
        myCurve2.Symbol.Fill = New Fill(Color.White)

        ' Generate a red curve with diamond symbols, and "My Curve" in the legend
        Dim myCurve As LineItem = myPane.AddCurve("My Curve", _
            list2, Color.MediumVioletRed, SymbolType.Diamond)
        ' Fill the area under the curve with a white-green gradient
        myCurve.Line.Fill = New Fill(Color.White, Color.Green)
        ' Make the symbols opaque by filling them with white
        myCurve.Symbol.Fill = New Fill(Color.White)

        ' Set the XAxis to date type
        myPane.XAxis.Type = AxisType.Date
        myPane.XAxis.CrossAuto = True

        ' Fill the axis background with a color gradient
        myPane.Chart.Fill = New Fill(Color.White, Color.LightGoldenrodYellow, 45.0F)

        masterPane.AxisChange(g)
    End Sub

End Class
