<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:decimal-format NaN = "" decimal-separator = "." grouping-separator = "`"/>
<xsl:output method="html" encoding="windows-1251" omit-xml-declaration="yes" standalone="no" indent="no"/>

<xsl:variable name="lang" select="document(//root/@language)/root"/>

<xsl:template match = "root">

<!--  -->
<table width="100%">
<tr><td class="icap" colspan="2"><xsl:value-of select="@NAME"/></td></tr>
<tr>
	<td class="iinfo" style="width:50%; text-align:right"><xsl:value-of select="$lang/album/@album"/>:&#160;</td>
	<td class="iinfo" style="text-align:left"><a href="default.aspx?groupid={@IDG}&amp;page=1"><xsl:value-of select="@PATH"/></a></td>
</tr>
<tr>
	<td class="iinfo" style="width:50%; text-align:right"><xsl:value-of select="$lang/album/@owner"/>:&#160;</td>
	<td class="iinfo" style="text-align:left"><a href="user_info.aspx?id={@OWNERID}"><xsl:value-of select="@OWNERNAME"/></a></td>
</tr>

<!--  -->
<tr>
	<td class="ifull" colspan="2">
		<img src="db/{@ID}_1.jpg" border="1" alt="{$lang/image/@size}: {@SIZEKB} {$lang/@kb}"/>
	</td>
</tr>
</table>

<!-- , ,  -->
<table width="100%">
<tr>
	<td class="icap" colspan="2"><xsl:value-of select="@NAME"/></td>
</tr>
<tr>
	<td class="iinfo" style="width:50%; text-align:right"><xsl:value-of select="$lang/album/@album"/>:&#160;</td>
	<td class="iinfo" style="text-align:left"><a href="default.aspx?groupid={@IDG}&amp;page=1"><xsl:value-of select="@PATH"/></a></td>
</tr>
<tr>
	<td class="iinfo" style="width:50%; text-align:right"><xsl:value-of select="$lang/album/@owner"/>:&#160;</td>
	<td class="iinfosel"><a href="user_info.aspx?id={@OWNERID}"><xsl:value-of select="@OWNERNAME"/></a></td>
</tr>
<tr>
	<td class="iinfo" style="width:50%; text-align:right"><xsl:value-of select="$lang/image/@sizes"/>:&#160;</td>
	<td class="iinfosel"><xsl:value-of select="@WIDTH"/> x <xsl:value-of select="@HEIGHT"/>
		<xsl:if test="@EXIF &gt; 0">
			<a href="#" onclick="exif({@ID})"><img class="ctrl" src="styles/i_exif.gif" border="0" alt="{$lang/image/@view_exif}"/></a>
		</xsl:if>
	</td>
</tr>
<tr>
	<td class="iinfo" style="width:50%; text-align:right"><xsl:value-of select="$lang/image/@size"/>:&#160;</td>
	<td class="iinfosel"><xsl:value-of select="@SIZEKB"/>&#160;<xsl:value-of select="$lang/@kb"/></td>
</tr>
<tr>
	<td class="iinfo" style="width:50%; text-align:right"><xsl:value-of select="$lang/image/@view_count"/>:&#160;</td>
	<td class="iinfosel"><xsl:value-of select="COUNTERS[@TYPE='T']/@VAL"/></td>
</tr>
<tr>
	<td class="iinfo" style="width:50%; text-align:right"><xsl:value-of select="$lang/image/@comments"/>:&#160;</td>
	<td class="iinfosel"><xsl:value-of select="count(COMMENTS)"/></td>
</tr>
<tr>
	<td class="iinfo" colspan="2">
		<a href="#"	onclick="comm({@ID}, 'new')"><xsl:value-of select="$lang/image/@comments_add"/></a>
	</td>
</tr>
<xsl:if test="count(COMMENTS) &gt; 0">
<tr>
	<td class="iinfo" colspan="2">
	<table width="50%" align="center">
		<xsl:for-each select="COMMENTS">
		<tr>
			<td class="thin" width="130px">
				<xsl:value-of select="@DT"/>
				<xsl:if test="(//root/@isadmin &gt; 0) or (//root/@USERID = @userid)">
					<a href="#" onclick="comm({@ID}, 'del')"><img class="ctrl" src="styles/i_delete.gif" border="0" alt="{$lang/@del}"/></a>
					<a href="#" onclick="comm({@ID}, 'edit')"><img class="ctrl" src="styles/i_info.gif" border="0" alt="{$lang/@edit}"/></a>
				</xsl:if>
			</td>
			<td class="thin" width="90px">
				<xsl:choose>
					<xsl:when test="@IDUSER &gt; 0">
						<a href="users/user_info.aspx?id={@IDUSER}"><xsl:value-of select="@USERNAME"/></a>
					</xsl:when>
					<xsl:otherwise>
						<xsl:choose>
							<xsl:when test="@USERMAIL"><a href="mailto:{@USERMAIL}?Subject={//root/@NAME}"><xsl:value-of select="@USERNAME"/></a></xsl:when>
							<xsl:otherwise><xsl:value-of select="@USERNAME"/></xsl:otherwise>
						</xsl:choose>
					</xsl:otherwise>
				</xsl:choose>
			</td>
			<td class="thin"><xsl:value-of select="@VAL"/></td>
		</tr>
		</xsl:for-each>		
	</table>
	</td>
</tr>
</xsl:if>
</table>
</xsl:template>

</xsl:stylesheet>