<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" omit-xml-declaration="yes" standalone="no" indent="no" />

<xsl:variable name="lang" select="document(//root/@language)/root"/>

<xsl:template match = "root">
<div>
	<a href="#" onclick="user(-1, 'new')"><xsl:value-of select="$lang/users/@create"/>
	</a>
</div>
<table width="100%">
<tr>
	<td class="thinsel" width="90px"><xsl:value-of select="$lang/users/@user"/></td>
	<td class="thinsel" width="120px"><xsl:value-of select="$lang/users/@lastenter"/></td>
	<td class="thinsel" width="90px"><xsl:value-of select="$lang/@stat"/></td>
	<td class="thinsel" style="text-align:left">
		<table>
		<tr>
			<td width="32px" align="center"><xsl:value-of select="$lang/users/@cnt"/></td>
			<td width="80px" align="center"><xsl:value-of select="$lang/users/@sumkb"/>,<div><xsl:value-of select="$lang/@kb"/></div></td>
			<td align="center" style="vertical-align:sub"><xsl:value-of select="$lang/album/@album"/></td>
		</tr>
		</table>
	</td>
	<td class="thinsel" width="10px"><xsl:value-of select="$lang/users/@comments"/></td>
</tr>
	<xsl:for-each  select='ITEM[not(@LOGIN = preceding-sibling::ITEM/@LOGIN)]'>
	<xsl:sort select="ITEM/@LOGIN" data-type="number" order="descending"/>
	<xsl:sort select="ITEM/@GROUP_ID" data-type="number" order="descending"/>
		<xsl:call-template name = "USER"><xsl:with-param name="login" select="@LOGIN"/></xsl:call-template>	
	</xsl:for-each>
<tr>
	<td class="thinft"></td>
	<td class="thinft"></td>
	<td class="thinft"></td>
	<td class="thinft" style="text-align:left">
		<table>
		<tr>
			<td width="32px" align="center"><xsl:value-of select="sum(ITEM/@IMG_COUNT)"/></td>
			<td width="80px" align="center"><xsl:value-of select="format-number(sum(ITEM/@IMG_SIZE) div 1024, '###.#')"/></td>
			<td align="center" style="vertical-align:sub"></td>
		</tr>
		</table>
	</td>
	<td class="thinft"></td>
</tr>
</table>
</xsl:template>

<xsl:template name = "USER">
<xsl:param name="login"/>
<xsl:variable name="content" select="//root/ITEM[@LOGIN=$login]"/>
<tr>
	<td class="thin">
		<a href="#" onclick="if(window.confirm('{$lang/users/@del_confirm}')) user({@ID}, 'del')"><img class="ctrl" src="../styles/i_delete.gif" border="0" alt="{$lang/@del}"/></a>
		<a href="#" onclick="user({@ID}, 'edit')"><xsl:value-of select="$content/@LOGIN"/></a>
	</td>
	<td class="thin"><xsl:value-of select="$content/@LASTENTER"/></td>
	<td class="thin">
		<div><xsl:value-of select="count($content)"/>&#160;<xsl:value-of select="$lang/users/@albums"/></div>
		<div>
			<xsl:if test="sum($content/@IMG_COUNT) &gt; 0">
				<xsl:value-of select="format-number(sum($content/@IMG_COUNT), '### ###')"/>&#160;<xsl:value-of select="$lang/users/@images"/>
			</xsl:if>
		</div>
		<div>
			<xsl:if test="sum($content/@IMG_SIZE) &gt; 0">
				<xsl:value-of select="format-number(sum($content/@IMG_SIZE) div 1024, '###.#')"/>&#160;<xsl:value-of select="$lang/@kb"/>
			</xsl:if>
		</div>
	</td>	
	<td class="thin">
		<xsl:for-each select="$content">
		<table>
		<tr>
			<td width="32px" align="center"><xsl:if test="@IMG_COUNT"><xsl:value-of select="@IMG_COUNT"/></xsl:if></td>
			<td width="80px" align="center"><xsl:if test="@IMG_SIZE"><xsl:value-of select="format-number(@IMG_SIZE div 1024, '###.#')"/></xsl:if></td>
			<td>
				<a href="#" onclick="if(window.confirm('{$lang/album/@del_confirm}')) album({@GROUP_ID}, 'del', null, '../')">
					<img class="ctrl" src="../styles/i_delete.gif" border="0" alt="{$lang/@del}"/>
				</a>
				<a href="default.aspx?groupid={@GROUP_ID}&amp;page=1"><xsl:value-of select="@GROUP_PATH"/>
			</a>
			</td>	
		</tr>
		</table>
		</xsl:for-each>
	</td>
	<td class="thin"><xsl:value-of select="@COMM_CNT"/></td>
</tr>

</xsl:template>

</xsl:stylesheet>
