<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" encoding="windows-1251" omit-xml-declaration="yes" standalone="no" indent="no"/>

<xsl:variable name="lang" select="document(//root/@language)/root"/>

<xsl:template match = "root">
<xsl:variable name="IDP" select="//group[@ID=//root/@IDG]/@IDP"/>
<xsl:variable name="SELGRP_IDUSER" select="//group[@ID=//root/@IDG]/@IDUSER"/>
<div class="mtitle"><xsl:value-of select="@GALLERY"/></div>
<div>
	<xsl:call-template name="group">
		<xsl:with-param name = "idp" select = "//root/@ID"/>
		<xsl:with-param name = "level" select = "0"/>
	</xsl:call-template>	
</div>

<xsl:choose>
	<xsl:when test="@userid &gt; 0">
		<div class="sep"></div>
		<div class="mtitle"><xsl:value-of select="$lang/@albums"/></div>
		<xsl:choose>
			<xsl:when test="($SELGRP_IDUSER=@userid) or (@isadmin=1)">
				<div><a href="#" onclick="album({@IDG}, 'new')"><xsl:value-of select="$lang/album/@create"/></a></div>
				<div><a href="#" onclick="album({@IDG}, 'edit')"><xsl:value-of select="$lang/album/@edit"/></a></div>
				<div><a href="#" onclick="if(window.confirm('{$lang/album/@del_confirm}')) album({@IDG}, 'del', {$IDP})"><xsl:value-of select="$lang/album/@del"/></a></div>
				
				<div class="sep"></div>
				<div class="mtitle"><xsl:value-of select="$lang/@images"/></div>
				<div><a href="#" onclick="upload({@IDG})"><xsl:value-of select="$lang/image/@add"/></a></div>
				<div><a href="search"><xsl:value-of select="$lang/@search"/></a></div>
				<div><a href="stg/basket.aspx"><xsl:value-of select="$lang/@basket"/>
					<xsl:if test="@BASKET_COUNT &gt; 0"><span class="icount"> (<xsl:value-of select="@BASKET_COUNT"/>)</span></xsl:if>
				</a></div>
				<xsl:if test="@isadmin='1'">
					<div class="sep"></div>
					<div class="mtitle"><xsl:value-of select="$lang/@control"/></div>
					<div><a href="users"><xsl:value-of select="$lang/control/@users"/></a>
					</div>
				</xsl:if>
			</xsl:when>
			<xsl:otherwise>
				<div class="dis"><xsl:value-of select="$lang/album/@create"/></div>
				<div class="dis"><xsl:value-of select="$lang/album/@edit"/></div>
				<div class="dis"><xsl:value-of select="$lang/album/@del"/></div>			
				<div class="sep"></div>
				<div class="mtitle"><xsl:value-of select="$lang/@images"/></div>
				<div class="dis"><xsl:value-of select="$lang/images/add"/></div>
				<div><a href="search"><xsl:value-of select="$lang/@search"/></a></div>
				<div><a href="stg/basket.aspx"><xsl:value-of select="$lang/@basket"/>
					<xsl:if test="@BASKET_COUNT &gt; 0"><span class="icount"> (<xsl:value-of select="@BASKET_COUNT"/>)</span></xsl:if>
				</a></div>
			</xsl:otherwise>
		</xsl:choose>
		<div class="sep"></div>
		<div class="mtitle"><xsl:value-of select="$lang/@stat"/></div>
		<div><xsl:value-of select="$lang/stat/@current_user"/>: <a href="user_info.aspx?id={@userid}"><xsl:value-of select="@username"/></a></div>
		<div><xsl:value-of select="$lang/stat/@last_enter"/>: <xsl:value-of select="@lastenter"/></div>
	</xsl:when>
	<xsl:otherwise>
		<div class="sep"></div>
		<div class="mtitle"><xsl:value-of select="$lang/@albums"/></div>
		<div class="dis"><xsl:value-of select="$lang/album/@create"/></div>
		<div class="dis"><xsl:value-of select="$lang/album/@edit"/></div>
		<div class="dis"><xsl:value-of select="$lang/album/@del"/></div>			
		<div class="sep"></div>
		<div class="mtitle"><xsl:value-of select="$lang/@images"/></div>
		<div class="dis"><xsl:value-of select="$lang/images/add"/></div>
		<div><a href="search"><xsl:value-of select="$lang/@search"/></a></div>
		<div><a href="stg/basket.aspx"><xsl:value-of select="$lang/@basket"/>
			<xsl:if test="@BASKET_COUNT &gt; 0"><span class="icount"> (<xsl:value-of select="@BASKET_COUNT"/>)</span></xsl:if>
		</a></div>
		<div class="sep"></div>
		<div><a href="login.aspx"><b><xsl:value-of select="$lang/@enter"/></b></a></div>
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!-- for each group, recursive -->
<xsl:template name = "group">
	<xsl:param name="idp"/>
	<xsl:param name="level"/>
	<xsl:variable name="pad" select="$level *12"/>
	<xsl:variable name="items" select="//root/group[@IDP=$idp]"/>
<xsl:for-each select="//root/group[@IDP=$idp]">
<xsl:sort select="@NAME"/>
	<div><xsl:if test="$level &gt; 0"><xsl:attribute name="class">mi</xsl:attribute></xsl:if>
		<a href="?groupid={@ID}&amp;page=1">
			<xsl:if test="@ID = (//root/@IDG)">
				<xsl:attribute name="class">selected</xsl:attribute>
			</xsl:if>
			<xsl:if test="//root/@userid &gt; 0"><!--      -->
				<xsl:choose>
					<xsl:when test="@ACC=2"><xsl:attribute name="style">color:red</xsl:attribute></xsl:when>
					<xsl:when test="@ACC=1"><xsl:attribute name="style">color:olive</xsl:attribute></xsl:when>
				</xsl:choose>
			</xsl:if>
			<xsl:value-of select="@NAME"/>
			<xsl:if test="@ICOUNT &gt; 0">
				<span class="icount"> (<xsl:value-of select="@ICOUNT"/>)</span>
			</xsl:if>
		</a>
		<xsl:call-template name="group">
			<xsl:with-param name = "idp" select = "@ID"/>
			<xsl:with-param name = "level" select = "$level +1"/>
		</xsl:call-template>	
	</div>
</xsl:for-each>
</xsl:template>

</xsl:stylesheet>
