<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" omit-xml-declaration="yes" standalone="no" indent="no" />
<xsl:decimal-format NaN = "" decimal-separator = "." grouping-separator = "`"/>
<xsl:variable name="lang" select="document(//root/@language)/root"/>

<xsl:template match = "root">
<table width="100%">
<tr>
	<td><xsl:value-of select="$lang/searchres/@caption"/>:
		<xsl:choose>
			<xsl:when test="count(ITEM)=0"><xsl:value-of select="$lang/searchres/@notfound"/></xsl:when>
			<xsl:when test="count(ITEM) &gt;= 30"><xsl:value-of select="$lang/searchres/@showfirst"/>&#160;<xsl:value-of select="count(ITEM)"/></xsl:when>
			<xsl:otherwise><xsl:value-of select="$lang/searchres/@found"/>&#160;<xsl:value-of select="count(ITEM)"/>&#160;<xsl:value-of select="$lang/searchres/@matches"/></xsl:otherwise>
		</xsl:choose>
	</td>
</tr>
</table>

<table width="100%">
	<xsl:apply-templates/>
</table>

</xsl:template>

<!--     -->
<xsl:template match = "ITEM">
<tr>
	<td class="thin" width="{//root/@MAX_TH_WIDTH}px" style="padding:4px; text-align:center">
		<a class="th" href="../image_view.aspx?id={@ID}">
			<img class="th" src="db/{@ID}_0.jpg" width="{@WIDTH_TH}px" hegiht="{@HEIGHT_TH}px" border="1"/>
		</a>
	</td>
	<td class="thin" style="vertical-align:sub">
		<div>
			<a href="#" onclick="bask({@ID}, 'new', '../')"><img class="ctrl" src="../styles/i_bask.gif" border="0" alt="{$lang/image/@add_to_basket} ({@SIZEKB} {$lang/@kb})"/></a>
			<b><xsl:value-of select="@NAME"/></b>
		</div>
		<div><xsl:value-of select="$lang/album/@album"/>: <a href="../default.aspx?groupid={@IDG}&amp;page=1"><xsl:value-of select="@PATH"/></a></div>
		<div><xsl:value-of select="$lang/image/@size"/>: <span class="iisel"><xsl:value-of select="@WIDTH"/> x <xsl:value-of select="@HEIGHT"/></span>
		<xsl:if test="@EXIF &gt; 0">
			<a href="#" onclick="exif({@ID}, '../');"><img class="ctrl" src="../styles/i_exif.gif" border="0" alt="{$lang/image/@view_exif}"/></a>
		</xsl:if>
		</div>
		<div><xsl:value-of select="$lang/image/@view_count"/>: <span class="iisel"><xsl:value-of select="@CNT_TOTAL"/></span>/<span class="iisel"><xsl:value-of select="@CNT_DAILY"/></span></div>
	</td>
	<td class="thin" style="vertical-align:sub; text-align:right" width="120px"><xsl:value-of select="@SIZEKB"/>&#160;<xsl:value-of select="$lang/@kb"/></td>
</tr>
</xsl:template>

</xsl:stylesheet>
