<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" omit-xml-declaration="yes" standalone="no" indent="no" />

<xsl:template match = "root">

<div width="100%" class="title" align="center"><xsl:value-of select="@NAME"/></div>
<table width="100%">
	<xsl:call-template name = "TAG"><xsl:with-param name="needtype" select="'Basic'"/></xsl:call-template>
	<xsl:call-template name = "TAG"><xsl:with-param name="needtype" select="'Specific'"/></xsl:call-template>
	<xsl:call-template name = "TAG"><xsl:with-param name="needtype" select="'Extended'"/></xsl:call-template>
</table>

</xsl:template>

<xsl:template name = "TAG">
<xsl:param name="needtype"/>
<xsl:variable name="tags" select="//root/TAG"/>
<tr><td class="thinsel" colspan="3">
	<xsl:value-of select="$needtype"/>
</td></tr>
<xsl:for-each select="$tags[@TYPE=$needtype]">
<tr>
	<td class="thin" align="right"><xsl:value-of select="@IDTAG"/></td>
	<td class="thin">
		<xsl:if test="@STYLE">
			<xsl:attribute name="style"><xsl:value-of select="@STYLE"/></xsl:attribute>
		</xsl:if>
		<xsl:value-of select="@NAME"/>
	</td>
	<td class="thin">
		<xsl:if test="@STYLE">
			<xsl:attribute name="style"><xsl:value-of select="@STYLE"/></xsl:attribute>
		</xsl:if>
		<xsl:value-of select="@VAL"/>
	</td>
</tr>
</xsl:for-each>

</xsl:template>

</xsl:stylesheet>
