<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" omit-xml-declaration="yes" standalone="no" indent="no" />
<xsl:decimal-format NaN = "" decimal-separator = "." grouping-separator = "`"/>

<xsl:variable name="lang" select="document(//root/@language)/root"/>

<xsl:template match = "root">
<table width="100%">
<tr>
	<td colspan="2"><xsl:value-of select="$lang/album/@album"/>: <xsl:call-template name="parent_albums"/></td>
</tr>
<tr>
	<td width="220px"><xsl:value-of select="$lang/album/@owner"/>: <a href="user_info.aspx?id={@OWNERID}"><xsl:value-of select="@OWNER"/></a></td>
</tr>
<tr>
	<td colspan="2" style="text-align:center">
	<xsl:if test="(count(item[@TYPE='image']) &gt; 0)">
		<div id="toppages">
			<script>genpages(toppages,
				<xsl:value-of select="@IDG"/>,
				1,
				<xsl:value-of select="@pages_total"/>,
				<xsl:value-of select="@page_current"/>,
				'<xsl:value-of select="$lang/album/@pages"/>'
				)</script></div>
	</xsl:if>
	</td>
</tr>	
</table>

<xsl:if test="count(item) &gt; 0">
	<table width="100%">
	<xsl:call-template name="ROW">
		<xsl:with-param name="rid" select="0"/>
	</xsl:call-template>
	</table>
</xsl:if>

<table width="100%">
<tr>
	<td style="text-align:center">
	<xsl:if test="(count(item[@TYPE='image']) &gt; 0)">
		<div id="bottompages"><script>genpages(bottompages,
			<xsl:value-of select="@IDG"/>,
			1,
			<xsl:value-of select="@pages_total"/>,
			<xsl:value-of select="@page_current"/>,
			'<xsl:value-of select="$lang/album/@pages"/>')</script></div>
	</xsl:if>
	</td>
</tr>
</table>
</xsl:template>

<xsl:template name="parent_albums">
<a href="#"><xsl:value-of select="//root/@GALLERY"/></a>
<xsl:for-each select="parent_album">
	&#187; <a href="?groupid={@ID}&amp;page=1"><xsl:value-of select="@NAME"/></a>
</xsl:for-each>
</xsl:template>

<!--   () -->
<xsl:template name = "item">
	<xsl:param name="rid"/>
	<xsl:param name="cid"/>
<xsl:param name="atposition"/>
<xsl:variable name="img" select="//item[position() = $atposition]"/>
<table width="100%">
<tr>
	<td align="center" style="vertical-align:baseline">
	<xsl:choose>
		<xsl:when test="$img/@TYPE='child'">
			<a class="th" href="?groupid={$img/@ID}">
				<img class="th" src="styles/i_album.gif" border="0"/>
				<div><xsl:value-of select="$img/@NAME"/>
					<xsl:if test="$img/@ICOUNT &gt; 0">
						<span class="icount"> (<xsl:value-of select="$img/@ICOUNT"/>)</span>
					</xsl:if>
				</div>
			</a>
		</xsl:when>
		<xsl:otherwise>
			<div><a class="th" href="image_view.aspx?id={$img/@ID}">
				<img class="th" src="db/{$img/@ID}_0.jpg" width="{$img/@WIDTH_TH}px" height="{$img/@HEIGHT_TH}px" border="1" alt="{$lang/image/@size}: {$img/@SIZEKB} {$lang/@kb}"/>
			</a></div>
			<xsl:if test="$img/@EXIF &gt; 0"><a href="#" onclick="exif({$img/@ID})"><img class="ctrl" src="styles/i_exif.gif" border="0" alt="{$lang/image/@view_exif}"/></a></xsl:if>
			<a href="#" onclick="bask({$img/@ID},'new')"><img class="ctrl" src="styles/i_bask.gif" border="0" alt="{$lang/image/@add_to_basket} ({$img/@SIZEKB} {$lang/@kb})"/></a>
			<xsl:if test="//root/@userid &gt; 0"><a href="#" onclick="del({$img/@ID})"><img class="ctrl" src="styles/i_delete.gif" border="0" alt="{$lang/@del}"/></a></xsl:if>
			<xsl:if test="$img/@CNT_TOTAL &gt; 0"><span class="icnt"><xsl:value-of select="$img/@CNT_TOTAL"/></span></xsl:if>
			<div><a class="thn" href="image_view.aspx?id={$img/@ID}"><xsl:value-of select="$img/@NAME"/></a>	</div>
		</xsl:otherwise>
	</xsl:choose>
	</td>
</tr>
</table>
</xsl:template>

<!--    -->
<xsl:template name = "ROW">
	<xsl:param name="rid"/>
<xsl:if test="$rid &lt; //root/@ROWS">
<tr>
	<xsl:call-template name="COL">
		<xsl:with-param name="cid" select="0"/>
		<xsl:with-param name="rid" select="$rid"/>
	</xsl:call-template>
</tr>
<xsl:call-template name="ROW">
	<xsl:with-param name="rid" select="$rid +1"/>
</xsl:call-template>
</xsl:if>
</xsl:template>

<!--   -->
<xsl:template name = "COL">
	<xsl:param name="cid"/>
	<xsl:param name="rid"/>
<xsl:if test="($cid &lt; //root/@COLS) and ($rid * //root/@COLS + $cid) &lt; count(//root/item)">
<xsl:variable name="atposition" select = "$rid * //root/@COLS + $cid"/>
<xsl:variable name="tdwidth" select = "100 div //root/@COLS"/>
<td class="th" width="{$tdwidth}%">
	<xsl:call-template name="item">
		<xsl:with-param name="rid" select="$rid"/>
		<xsl:with-param name="cid" select="$cid"/>
		<xsl:with-param name="atposition" select="$atposition +1"/>
	</xsl:call-template>
</td>
<xsl:call-template name="COL">
	<xsl:with-param name="cid" select="$cid +1"/>
	<xsl:with-param name="rid" select="$rid"/>
</xsl:call-template>
</xsl:if>
</xsl:template>

</xsl:stylesheet>