<?xml version="1.0" encoding="windows-1251"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" omit-xml-declaration="yes" standalone="no" indent="no" />
<xsl:variable name="lang" select="document(//root/@language)/root"/>

<xsl:template match = "root">

<div width="100%" class="title" align="center"><xsl:value-of select="$lang/basket/@caption"/></div>
<div><a href="#" onclick="window.open('to_basket.aspx?id=-1&amp;oper=del', '', 'width=320,height=100,toolbar=no,menubar=no,status=yes'); return false;"><xsl:value-of select="$lang/basket/@clear"/></a></div>
<div><a href="basket.zip"><xsl:value-of select="$lang/basket/@download"/></a></div>

<table width="100%">
<tr>
	<td class="thinsel"><xsl:value-of select="$lang/basket/@total"/>: <span class="iisel"><xsl:value-of select="count(IMAGE)"/></span></td>
	<td class="thinsel"></td>
	<td class="thinsel" style="text-align:right"><span class="iisel">
		<xsl:value-of select="format-number(sum(IMAGE/@SIZE) div 1024, '# ###.0')"/>&#160;<xsl:value-of select="$lang/@kb"/></span>
	</td>
</tr>
<xsl:apply-templates/>
</table>

</xsl:template>

<xsl:template match = "IMAGE">
<tr>
	<td class="thin" width="{@MAX_TH_WIDTH}px" style="padding:4px; text-align:center">
		<a class="th" href="../image_view.aspx?id={@ID}">
			<img class="th" src="db/{@ID}_0.jpg" width="{@WIDTH_TH}px" hegiht="{@HEIGHT_TH}px" border="1"/>
		</a>
	</td>
	<td class="thin" style="vertical-align:sub">
		<div>
			<a href="#" onclick="bask({@ID}, 'del', '../')">
				<img class="ctrl" src="../styles/i_delete.gif" border="0" alt="{$lang/basket/@remove}"/>
			</a><b><xsl:value-of select="@NAME"/></b>
		</div>
		<div class="sep"/>
		<div><xsl:value-of select="$lang/album/@album"/>: <a href="../default.aspx?groupid={@IDG}&amp;page=1"><xsl:value-of select="@PATH"/></a></div>
		<div><xsl:value-of select="$lang/image/@sizes"/>: <span class="iisel"><xsl:value-of select="@WIDTH"/> x <xsl:value-of select="@HEIGHT"/></span>
			<xsl:if test="@EXIF &gt; 0">
			<a href="#" onclick="exif({@ID}, '../')">
				<img class="ctrl" src="../styles/i_exif.gif" border="0" alt="{$lang/image/@view_exif}"/>
			</a>		
			</xsl:if>
		</div>
		<div><xsl:value-of select="$lang/image/@view_count"/>: <span class="iisel"><xsl:value-of select="@CNT_TOTAL"/></span>/<span class="iisel"><xsl:value-of select="@CNT_DAILY"/></span></div>
	</td>
	<td class="thin" style="vertical-align:sub; text-align:right" width="120px"><xsl:value-of select="@SIZEKB"/>&#160;<xsl:value-of select="$lang/@kb"/></td>
</tr>

</xsl:template>

</xsl:stylesheet>
