CREATE TABLE [dbo].[COMM] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[IDI] [int] NOT NULL ,
	[IDUSER] [int] NULL ,
	[USERNAME] [varchar] (50) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[USERMAIL] [varchar] (50) COLLATE Cyrillic_General_CI_AS NULL ,
	[DT] [datetime] NOT NULL ,
	[VAL] [text] COLLATE Cyrillic_General_CI_AS NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[COUNTERS] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[IDI] [int] NOT NULL ,
	[TYPE] [char] (1) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[VAL] [int] NOT NULL ,
	[VALD] [int] NOT NULL ,
	[LASTUPD] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[EXIF] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[IDI] [int] NOT NULL ,
	[IDTAG] [int] NOT NULL ,
	[VAL] [varchar] (250) COLLATE Cyrillic_General_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[EXIF_CAT] (
	[ID] [int] NOT NULL ,
	[TYPE] [varchar] (24) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[NAME] [varchar] (50) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[STYLE] [varchar] (50) COLLATE Cyrillic_General_CI_AS NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[GRPS] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[IDP] [int] NULL ,
	[NAME] [varchar] (120) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[IDUSER] [int] NOT NULL ,
	[ACC] [int] NOT NULL ,
	[ROWS] [int] NOT NULL ,
	[COLS] [int] NOT NULL ,
	[BORN] [datetime] NOT NULL ,
	[THWID] [int] NOT NULL ,
	[THHEI] [int] NOT NULL ,
	[SORT] [char] (1) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[SORTORDER] [int] NOT NULL ,
	[LASTUPD] [datetime] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[IMGB] (
	[IDI] [int] NOT NULL ,
	[TYPE] [int] NOT NULL ,
	[WIDTH] [int] NOT NULL ,
	[HEIGHT] [int] NOT NULL ,
	[BODY] [image] NULL ,
	[BODYSIZE] AS (datalength([BODY])) ,
	[LASTUPD] [datetime] NOT NULL 
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
GO

CREATE TABLE [dbo].[IMGS] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[IDG] [int] NOT NULL ,
	[NAME] [varchar] (50) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[FNAME] [varchar] (50) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[FDATE] [datetime] NOT NULL ,
	[S_ID] [varchar] (20) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[S_DATE] [varchar] (20) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[S_WH] [varchar] (20) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[S_HW] [varchar] (20) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[S_SIZE] [varchar] (20) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[S_COMM] [varchar] (20) COLLATE Cyrillic_General_CI_AS NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[SORTNAMES] (
	[ID] [char] (1) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[NAME] [varchar] (50) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[POS] [int] NOT NULL 
) ON [PRIMARY]
GO

CREATE TABLE [dbo].[USERS] (
	[ID] [int] IDENTITY (1, 1) NOT NULL ,
	[LOGIN] [varchar] (50) COLLATE Cyrillic_General_CI_AS NOT NULL ,
	[PWD] [varchar] (50) COLLATE Cyrillic_General_CS_AS NULL ,
	[LASTENTER] [datetime] NOT NULL ,
	[CREATED] [datetime] NOT NULL ,
	[NAME] [varchar] (200) COLLATE Cyrillic_General_CI_AS NULL ,
	[EMAIL] [varchar] (120) COLLATE Cyrillic_General_CI_AS NULL ,
	[ICQ] [varchar] (50) COLLATE Cyrillic_General_CI_AS NULL ,
	[STATE] [int] NOT NULL ,
	[ADMIN] [int] NOT NULL ,
	[LIMGSIZE] [int] NOT NULL ,
	[LIMGCNT] [int] NOT NULL ,
	[LGRPSIZE] [int] NOT NULL ,
	[LGRPCNT] [int] NOT NULL ,
	[LTOTALSZ] [int] NOT NULL ,
	[COMMENT] [varchar] (200) COLLATE Cyrillic_General_CI_AS NULL 
) ON [PRIMARY]
GO

ALTER TABLE [dbo].[COMM] WITH NOCHECK ADD 
	CONSTRAINT [PK_COMM] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[COUNTERS] WITH NOCHECK ADD 
	CONSTRAINT [PK_COUNTERS] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[EXIF] WITH NOCHECK ADD 
	CONSTRAINT [PK_EXIF] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[EXIF_CAT] WITH NOCHECK ADD 
	CONSTRAINT [PK_EXIF_CAT] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[GRPS] WITH NOCHECK ADD 
	CONSTRAINT [PK_GRPS] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[IMGB] WITH NOCHECK ADD 
	CONSTRAINT [PK_IMGB] PRIMARY KEY  CLUSTERED 
	(
		[IDI],
		[TYPE]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[IMGS] WITH NOCHECK ADD 
	CONSTRAINT [PK_IMGS] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[SORTNAMES] WITH NOCHECK ADD 
	CONSTRAINT [PK_SORTNAMES] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[USERS] WITH NOCHECK ADD 
	CONSTRAINT [PK_USERS] PRIMARY KEY  CLUSTERED 
	(
		[ID]
	)  ON [PRIMARY] 
GO

ALTER TABLE [dbo].[COMM] WITH NOCHECK ADD 
	CONSTRAINT [DF_COMM_DT] DEFAULT (getdate()) FOR [DT]
GO

ALTER TABLE [dbo].[COUNTERS] WITH NOCHECK ADD 
	CONSTRAINT [DF_COUNTERS_TYPE] DEFAULT ('T') FOR [TYPE],
	CONSTRAINT [DF_COUNTERS_VAL] DEFAULT (0) FOR [VAL],
	CONSTRAINT [DF_COUNTERS_VALD] DEFAULT (0) FOR [VALD],
	CONSTRAINT [DF_COUNTERS_LASTUPD] DEFAULT (getdate()) FOR [LASTUPD],
	CONSTRAINT [CK_COUNTERS] CHECK ([TYPE] = 'B' or [TYPE] = 'T')
GO

ALTER TABLE [dbo].[GRPS] WITH NOCHECK ADD 
	CONSTRAINT [DF_GRPS_IDUSER] DEFAULT (1) FOR [IDUSER],
	CONSTRAINT [DF_GRPS_ACC] DEFAULT (0) FOR [ACC],
	CONSTRAINT [DF_GRPS_ROWS] DEFAULT (3) FOR [ROWS],
	CONSTRAINT [DF_GRPS_COLS] DEFAULT (4) FOR [COLS],
	CONSTRAINT [DF_GRPS_BORN] DEFAULT (getdate()) FOR [BORN],
	CONSTRAINT [DF_GRPS_THWID] DEFAULT (160) FOR [THWID],
	CONSTRAINT [DF_GRPS_THHEI] DEFAULT (120) FOR [THHEI],
	CONSTRAINT [DF_GRPS_SORT] DEFAULT ('N') FOR [SORT],
	CONSTRAINT [DF_GRPS_SORTORDER] DEFAULT (0) FOR [SORTORDER],
	CONSTRAINT [DF_GRPS_LASTUPD] DEFAULT (getdate()) FOR [LASTUPD],
	CONSTRAINT [CK_GRPS] CHECK ([ROWS] > 0 and [COLS] > 0),
	CONSTRAINT [CK_GRPS_1] CHECK ([ACC] = 2 or ([ACC] = 1 or [ACC] = 0))
GO

ALTER TABLE [dbo].[IMGB] WITH NOCHECK ADD 
	CONSTRAINT [DF_IMGB_TYPE] DEFAULT (0) FOR [TYPE],
	CONSTRAINT [DF_IMGB_LASTUPD] DEFAULT (getdate()) FOR [LASTUPD],
	CONSTRAINT [CK_IMGB] CHECK ([TYPE] = 1 or [TYPE] = 0)
GO

ALTER TABLE [dbo].[IMGS] WITH NOCHECK ADD 
	CONSTRAINT [DF_IMGS_FDATE] DEFAULT (getdate()) FOR [FDATE],
	CONSTRAINT [DF_IMGS_S_ID] DEFAULT ('0') FOR [S_ID],
	CONSTRAINT [DF_IMGS_S_DATE] DEFAULT ('0') FOR [S_DATE],
	CONSTRAINT [DF_IMGS_S_WH] DEFAULT ('0') FOR [S_WH],
	CONSTRAINT [DF_IMGS_S_HW] DEFAULT ('0') FOR [S_HW],
	CONSTRAINT [DF_IMGS_S_SIZE] DEFAULT ('0') FOR [S_SIZE],
	CONSTRAINT [DF_IMGS_S_COMM] DEFAULT ('0') FOR [S_COMM],
	CONSTRAINT [CK_IMGS] CHECK ([FDATE] >= '19780101')
GO

ALTER TABLE [dbo].[SORTNAMES] WITH NOCHECK ADD 
	CONSTRAINT [DF_SORTNAMES_POS] DEFAULT (0) FOR [POS]
GO

ALTER TABLE [dbo].[USERS] WITH NOCHECK ADD 
	CONSTRAINT [DF_USERS_LASTENTER] DEFAULT (getdate()) FOR [LASTENTER],
	CONSTRAINT [DF_USERS_CREATED] DEFAULT (getdate()) FOR [CREATED],
	CONSTRAINT [DF_USERS_STATE] DEFAULT (1) FOR [STATE],
	CONSTRAINT [DF_USERS_ADMIN] DEFAULT (0) FOR [ADMIN],
	CONSTRAINT [DF_USERS_LIM_SIZE] DEFAULT (0) FOR [LIMGSIZE],
	CONSTRAINT [DF_USERS_LIM_CNT] DEFAULT (0) FOR [LIMGCNT],
	CONSTRAINT [DF_USERS_LGRPSIZE] DEFAULT (0) FOR [LGRPSIZE],
	CONSTRAINT [DF_USERS_LGRPCNT] DEFAULT (0) FOR [LGRPCNT],
	CONSTRAINT [DF_USERS_LTOTAL] DEFAULT (0) FOR [LTOTALSZ],
	CONSTRAINT [CK_USERS] CHECK ([STATE] = 1 or [STATE] = 0)
GO

 CREATE  UNIQUE  INDEX [IX_COUNTERS] ON [dbo].[COUNTERS]([IDI], [TYPE]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_IMGS_ID] ON [dbo].[IMGS]([S_ID]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_IMGS_DATE] ON [dbo].[IMGS]([S_DATE]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_IMGS_WH] ON [dbo].[IMGS]([S_WH]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_IMGS_HW] ON [dbo].[IMGS]([S_HW]) ON [PRIMARY]
GO

 CREATE  INDEX [IX_IMGS_SIZE] ON [dbo].[IMGS]([S_SIZE]) ON [PRIMARY]
GO

 CREATE  UNIQUE  INDEX [IX_USERS] ON [dbo].[USERS]([LOGIN]) ON [PRIMARY]
GO

ALTER TABLE [dbo].[COMM] ADD 
	CONSTRAINT [FK_COMM_IMGS] FOREIGN KEY 
	(
		[IDI]
	) REFERENCES [dbo].[IMGS] (
		[ID]
	) ON DELETE CASCADE ,
	CONSTRAINT [FK_COMM_USERS] FOREIGN KEY 
	(
		[IDUSER]
	) REFERENCES [dbo].[USERS] (
		[ID]
	) ON DELETE CASCADE 
GO

ALTER TABLE [dbo].[COUNTERS] ADD 
	CONSTRAINT [FK_COUNTERS_IMGS] FOREIGN KEY 
	(
		[IDI]
	) REFERENCES [dbo].[IMGS] (
		[ID]
	) ON DELETE CASCADE 
GO

ALTER TABLE [dbo].[EXIF] ADD 
	CONSTRAINT [FK_EXIF_EXIF_CAT] FOREIGN KEY 
	(
		[IDTAG]
	) REFERENCES [dbo].[EXIF_CAT] (
		[ID]
	),
	CONSTRAINT [FK_EXIF_IMGS] FOREIGN KEY 
	(
		[IDI]
	) REFERENCES [dbo].[IMGS] (
		[ID]
	) ON DELETE CASCADE 
GO

ALTER TABLE [dbo].[GRPS] ADD 
	CONSTRAINT [FK_GRPS_GRPS] FOREIGN KEY 
	(
		[IDP]
	) REFERENCES [dbo].[GRPS] (
		[ID]
	),
	CONSTRAINT [FK_GRPS_SORTNAMES] FOREIGN KEY 
	(
		[SORT]
	) REFERENCES [dbo].[SORTNAMES] (
		[ID]
	)
GO

ALTER TABLE [dbo].[IMGB] ADD 
	CONSTRAINT [FK_IMGB_IMGS] FOREIGN KEY 
	(
		[IDI]
	) REFERENCES [dbo].[IMGS] (
		[ID]
	) ON DELETE CASCADE 
GO

ALTER TABLE [dbo].[IMGS] ADD 
	CONSTRAINT [FK_IMGS_GRPS] FOREIGN KEY 
	(
		[IDG]
	) REFERENCES [dbo].[GRPS] (
		[ID]
	) ON DELETE CASCADE 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE view VEXIF
as
select	EXIF.*, EXIF_CAT.TYPE, EXIF_CAT.NAME, EXIF_CAT.STYLE
from	EXIF
join	EXIF_CAT on EXIF_CAT.ID=EXIF.IDTAG

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE view VGRPS
as
select	GRPS.*, OWNER=USERS.LOGIN, SORTNAME=SORTNAMES.NAME
from	GRPS
join	SORTNAMES on SORTNAMES.ID = GRPS.SORT
join	USERS on USERS.ID=GRPS.IDUSER

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE view VIMGS
as
select	IMGS.*,
	WIDTH=isnull(IMGB.WIDTH,0),
	HEIGHT=isnull(IMGB.HEIGHT,0),
	SIZE	=isnull(IMGB.BODYSIZE, 0),
	SIZEKB	=cast(round(IMGB.BODYSIZE/1024.0, 1) as numeric(18,1)),

	WIDTH_TH=isnull(ITH.WIDTH,0),
	HEIGHT_TH=isnull(ITH.HEIGHT,0),
	SIZE_TH	=isnull(ITH.BODYSIZE, 0),
	SIZEKB_TH	=cast(round(ITH.BODYSIZE/1024.0, 1) as numeric(18,1)),

	CNT_TOTAL	=isnull(cnt.VAL,0),
	CNT_DAILY	=isnull(cnt.VALD,0),

	USERID	=USERS.ID,
	USERNAME	=USERS.LOGIN
from	IMGS
join	GRPS on GRPS.ID=IMGS.IDG
join	USERS on USERS.ID=GRPS.IDUSER
left join IMGB ITH on ITH.IDI=IMGS.ID and ITH.TYPE=0
left join IMGB on IMGB.IDI=IMGS.ID and IMGB.TYPE=1
left join COUNTERS cnt on cnt.IDI=IMGS.ID and cnt.TYPE='T'

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure dbo.GET_PAGE(@ITEMS_ON_PAGE int, @IDG int, @START_FROM int, @userid int)
as
begin
	set nocount on
	declare @query nvarchar(4000)
	set @query = '
		select
			ID,
			TYPE=''child'',
			NAME,
			USERID	=IDUSER,
			USERNAME	=OWNER,
			ICOUNT	=(select count(1) from IMGS where IMGS.IDG=VGRPS.ID)
		from	VGRPS
		where	IDP = @IDG and dbo.I_CAN_VIEW(ID, @userID)=1 and '+cast(@START_FROM as varchar)+'=0
		order by VGRPS.NAME

		select top '+cast(@ITEMS_ON_PAGE as varchar)+'
			t1.ID,
			TYPE	=''image'',
			t1.IDG,
			t1.NAME,
			t1.FDATE,
			t1.WIDTH,	t1.HEIGHT,
			t1.SIZE,		t1.SIZEKB,
			t1.WIDTH_TH,	t1.HEIGHT_TH,
			t1.SIZE_TH,	t1.SIZEKB_TH,
			t1.CNT_TOTAL,
			t1.CNT_DAILY,
			t1.USERID,
			t1.USERNAME,
			EXIF	=(select count(1) from EXIF where EXIF.IDI = t1.ID)
		from    VIMGS t1
		join	GRPS on GRPS.ID=t1.IDG and dbo.I_CAN_VIEW(t1.ID, @userID)=1
		where	t1.IDG=@IDG and t1.ID not in (
			select	top '+cast(@START_FROM as varchar)+' t2.ID
			from	VIMGS t2
			join	GRPS g2 on g2.ID=t2.IDG and dbo.I_CAN_VIEW(g2.ID, @userid)=1
			where  t2.IDG=@IDG
			order by
				(case g2.SORT
				when ''N'' then t2.NAME
				when ''D'' then t2.S_DATE
				when ''S'' then t2.S_SIZE
				when ''W'' then t2.S_WH
				when ''H'' then t2.S_HW
				else t2.S_ID end))
		order by (case GRPS.SORT
			when ''N'' then t1.NAME
			when ''D'' then t1.S_DATE
			when ''S'' then t1.S_SIZE
			when ''W'' then t1.S_WH
			when ''H'' then t1.S_HW
			else t1.S_ID end)'
	exec sp_executesql @query, N'@IDG int, @userID int', @IDG, @userid
end
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE proc dbo.LOGIN @LOGIN varchar(50), @PASSWORD varchar(50)
as
begin
	declare @ID int, @dt datetime

	select @ID=ID, @DT = LASTENTER
	from	USERS
	where LOGIN=@LOGIN and (PWD COLLATE Cyrillic_General_CS_AS=@PASSWORD  COLLATE Cyrillic_General_CS_AS)
	if @ID is not NULL
		update	USERS
		set	LASTENTER=getdate()
		where	ID=@ID

	select ID=isnull(@ID,0), LASTENTER=@DT
end
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE proc dbo.PUT_IMAGE(
	@userID int,

	@IDG int,
	@NAME varchar(50),
	@FNAME varchar(50),

	@IMG_TH_WID int,
	@IMG_TH_HEI int,
	@IMG_TH image,

	@IMG_WID int,
	@IMG_HEI int,
	@IMG_FULL image)
as
begin
	declare @err varchar(200)
	set nocount on
	if (dbo.I_CAN_OPERATION(@IDG, @userID)<>1) begin
		raiserror ('You cannot place images into this album.', 16, 1)
		return
	end

	set transaction isolation level READ COMMITTED

	BEGIN TRANSACTION
		declare @ID int
		insert IMGS (IDG, NAME, FNAME)
		values (@IDG, @NAME, @FNAME)
		select @ID = @@identity
	
		insert IMGB (IDI, TYPE, WIDTH, HEIGHT, BODY)
		values (@ID, 0, @IMG_TH_WID, @IMG_TH_HEI, @IMG_TH)
	
		insert IMGB (IDI, TYPE, WIDTH, HEIGHT, BODY)
		values (@ID, 1, @IMG_WID, @IMG_HEI, @IMG_FULL)
	
		select @ID
	COMMIT TRANSACTION
end
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure dbo.SCRIPT_ME as
begin
	set nocount on
	select
		'insert EXIF_CAT(ID, TYPE, NAME, STYLE) '+
		'values ('+cast(ID as varchar)+', '''+TYPE+''', '''+NAME+''', ' +
		isnull(''''+style+'''', 'null')+')'
	from	EXIF_CAT

	select
		'insert SORTNAMES(ID, NAME, POS) '+
		'values ('''+ID+''', '''+NAME+''', '+cast(POS as varchar)+')'
	from	SORTNAMES


	select
		'insert USERS(LOGIN, PWD, STATE, ADMIN) values (''admin'', ''123'', 1, 1)'+char(13)+
		'declare @iduser int'+char(13)+
		'select @iduser = @@identity'+char(13)+
		'insert GRPS (NAME, IDUSER, ACC) values ('' admin'', @iduser, 0)'

end
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE procedure dbo.UPD_COUNTER @IDI int, @TYPE char(1), @userID int
as
begin
	declare @CID int

	set nocount on
	set transaction isolation level repeatable read

	BEGIN TRANSACTION

		select	top 1 @CID=ID
		from	COUNTERS
		where	IDI=@IDI and TYPE=@TYPE
		
		if @CID is NULL
			insert COUNTERS (IDI, TYPE, VAL) values (@IDI, @TYPE, 1)
		else 	
			update	COUNTERS
			set	VAL = (select t1.VAL from COUNTERS t1 where t1.ID=@CID)+1
			where	ID=@CID
	COMMIT TRANSACTION
end
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

create function dbo.ARR_TO_TABLE(@arr_comma_sep varchar(2000))
returns @res table(ID int not null)
as
begin
	declare @ipos int, @ID int
	set @arr_comma_sep = ltrim(rtrim(@arr_comma_sep))
	while @arr_comma_sep<>'' begin
		set @ipos = charindex(',', @arr_comma_sep)
		insert @res (ID) values (cast(substring(@arr_comma_sep, 1, @ipos-1) as int))
		set @arr_comma_sep = substring(@arr_comma_sep, @ipos+1, len(@arr_comma_sep)-@ipos)
	end
	return
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE function dbo.GET_PATH(@IDP int, @IDP2 int, @separator varchar(40), @userID int)
returns varchar(4000)
as
begin
	declare @result varchar(4000)
	declare @tnames table (ID int not null identity, FName varchar(250))
	set @result = ''
	set @idp = isnull(@idp, -1)
	while (@idp2<>@idp) begin
		set @result = @separator + isnull((select NAME from GRPS where ID=@IDP2), '') + @result
		set @idp2 = (select IDP from GRPS where ID=@IDP2)
	end
	if len(@result)>=len(@separator)
		set @result = right(@result, len(@result)-len(@separator))
	return ltrim(@result)
end




GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE function dbo.GET_TREE(@IDP int, @userID int, @Level int)	--not used now
returns @res table (
	IDG int,
	IDP int,
	Level int not null)
begin
	declare	@lev int
	set @lev = 0
	insert @res (IDG, IDP, Level) values (@IDP, NULL, 0)
	while (@@rowcount>0) and (@lev<@Level) begin
		set @lev = @lev+1
		insert	@res (IDG, IDP, Level)
		select	ID, IDP, @lev
		from	GRPS
		where	isnull(IDP,-1) in (select isnull(IDG,-1) from @res where Level=@lev-1) and
			dbo.I_CAN_VIEW(GRPS.ID, @userID)=1
	end
--	delete from @res where IDG=@IDP
	return
end



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE function dbo.GET_UPPER_GROUPS (@IDG int)
returns @res table (ID int not null, LEVEL int not null)
as
begin
	declare @tempID int, @tempLev int
	select	@tempID=ID
	from	GRPS
	where	ID=@IDG

	set @tempLev = 0
	while @tempID is NOT NULL begin
		insert	@res values (@tempID, @tempLev)
		select	@tempID=IDP
		from	GRPS
		where	ID=@tempID
		set @tempLev = @tempLev+1
	end
	return
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS OFF 
GO

CREATE function dbo.IMG_FIND(
	@userID int,
	@NAME varchar(50),
	@COMM varchar(50),
	@OWNER varchar(50),

	@SIZEFROM int,
	@SIZETO int,
	@DATEFROM datetime,
	@DATETO datetime,

	@ETAG_ID int,
	@ETAG_FROM varchar(50),
	@ETAG_TO	varchar(50))
returns
	@res table(ID int NOT NULL)
begin
	insert @res
	select top 30 IMGS.ID
	from	IMGS
	join	GRPS on GRPS.ID=IMGS.IDG
	join	USERS on USERS.ID=GRPS.IDUSER and (@OWNER is NULL or USERS.NAME like '%'+@OWNER+'%')
	join	IMGB on
		(IMGB.IDI=IMGS.ID and IMGB.TYPE=1) and
		(@SIZEFROM is NULL or IMGB.BODYSIZE>=@SIZEFROM*1024) and
		(@SIZETO is NULL or IMGB.BODYSIZE<=@SIZETO*1024)
	where
		(@NAME is NULL or IMGS.NAME like '%'+@NAME+'%') and
		(@COMM is NULL or exists(
			select	1
			from	COMM
			where COMM.IDI=IMGS.ID and COMM.VAL like '%'+@COMM+'%')) and
		(@ETAG_ID is NULL or exists(
			select	1
			from	EXIF
			where	EXIF.IDI=IMGS.ID and EXIF.IDTAG=@ETAG_ID and
				(@ETAG_FROM is NULL or EXIF.VAL>=@ETAG_FROM) and
				(@ETAG_TO is NULL or EXIF.VAL<@ETAG_TO))) and
		dbo.I_CAN_VIEW(IMGS.IDG, @userID)=1

	return
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE function dbo.I_CAN_OPERATION(@IDG int, @userID int)
returns int
begin
	return 1

	if not exists(
		select	1
		from	GRPS
		where	ID=@IDG and IDUSER=@userID) return 0
	return 1
end


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE function dbo.I_CAN_VIEW(@IDG int, @userID int)
returns int
begin

	if (@userID=0) and not exists(
		select	1
		from	GRPS
		where	ID in (select ID from dbo.GET_UPPER_GROUPS(@IDG)) and ACC>0) return 1

	if (@userID>0) and not exists(
		select	1
		from	GRPS
		where	ID in (select ID from dbo.GET_UPPER_GROUPS(@IDG)) and (ACC>1 and IDUSER<>@userID)) return 1

	return 0
end

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE function dbo.STUFF_INT(@VAL int, @LENGTH int)
returns varchar(20)
begin
	declare @SVAL varchar(20)
	set @SVAL = cast(@VAL as varchar(20))
	return (case when len(@SVAL)<@LENGTH then REPLICATE('0', @LENGTH-len(@SVAL))+@SVAL else @SVAL end)
end


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE TRIGGER TU_COMM ON [dbo].[COMM] 
FOR INSERT, UPDATE
AS
	update	COMM
	set	USERMAIL = null
	where	ID in (select ID from INSERTED i where charindex('@', i.USERMAIL)=0)

	update	COMM
	set	DT = getdate()
	where	ID in (select ID from INSERTED)

	update	IMGS
	set	S_COMM = S_COMM
	where	ID in (select distinct(IDI) from INSERTED)
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE TRIGGER TU_COUNTERS ON dbo.COUNTERS 
FOR INSERT, UPDATE
AS
	update	COUNTERS
	set	LASTUPD = getdate(),
		VALD	=(case when convert(varchar(12), LASTUPD, 112)<>convert(varchar(12), getdate(), 112) then 1 else VALD+1 end)
	where	ID in (select ID from INSERTED)

GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE TRIGGER TU_GRPS ON [dbo].[GRPS] 
FOR UPDATE
AS
	declare 	ACC_CORRECT cursor local for 
		select	GRPS.ID, i.ACC
		from	GRPS
		join	inserted i on i.ID=GRPS.ID
		join	deleted d on d.ID=GRPS.ID
		where	i.ACC>=d.ACC
	declare @ID int, @NEWACC int
	open ACC_CORRECT
	fetch from ACC_CORRECT into @ID, @NEWACC
	while @@FETCH_STATUS=0 begin

		update	GRPS
		set	ACC=@NEWACC
		where	ID in (select IDG from dbo.GET_TREE(@ID, -1, 255) where IDG<>@ID)

		fetch next from ACC_CORRECT into @ID, @NEWACC
	end
	deallocate ACC_CORRECT

	update	GRPS
	set	LASTUPD = getdate()
	where	ID in (select ID from inserted)
GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE TRIGGER TIU_IMGB ON [dbo].[IMGB] 
FOR INSERT, UPDATE
AS
	set nocount on

	update	IMGS
	set	S_WH	=cast(dbo.STUFF_INT(i.WIDTH, 4) + dbo.STUFF_INT(i.HEIGHT, 4) as varchar(20)),
		S_HW	=cast(dbo.STUFF_INT(i.HEIGHT, 4) + dbo.STUFF_INT(i.WIDTH, 4) as varchar(20)),
		S_SIZE	=dbo.STUFF_INT(datalength(IMGB.BODY), 8)
	from	IMGS
	join	INSERTED i on i.IDI=IMGS.ID and i.TYPE=1
	join	IMGB on IMGB.IDI = i.IDI and IMGB.TYPE=1

	update	IMGB
	set	LASTUPD = getdate()
	from	IMGB
	join	INSERTED i on i.IDI=IMGB.IDI and i.TYPE=IMGB.TYPE



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

CREATE TRIGGER TIU_IMGS ON dbo.IMGS 
FOR INSERT, UPDATE
AS
	set nocount on

	update	IMGS
	set	S_ID	=dbo.STUFF_INT(ID, 8),
		S_DATE = convert(varchar(20), FDATE, 120),
		S_COMM=dbo.STUFF_INT((select count(1) from COMM where COMM.IDI=IMGS.ID), 8)
	where	ID in (select ID from INSERTED)



GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE TRIGGER TU_USERS ON dbo.USERS 
FOR INSERT,UPDATE
AS
	update	USERS
	set	NAME = LOGIN
	where	ID in (select i.ID from inserted i where i.NAME='')


GO
SET QUOTED_IDENTIFIER OFF 
GO
SET ANSI_NULLS ON 
GO

