<%@ Page Language="VB" MasterPageFile="~/default.master" Title="Untitled Page" %>

<script runat="server">
    Dim urlHome As String = "http://" & System.Web.HttpContext.Current.Request.Url.Host & System.Web.Hosting.HostingEnvironment.ApplicationVirtualPath

    Protected Sub Page_Load(ByVal sender As Object, ByVal e As System.EventArgs)
        lnkHome.NavigateUrl = urlHome
        
        If Page.IsPostBack = False Then
            BindData()
        End If
    End Sub
    
    Public Function BuildPath(ByVal Path As String) As String
        Path = Path.Replace("\", "/")
        Path = Mid(Path, InStrRev(Path, "/Gallery"))
        Return Path
    End Function

    Protected Sub grid_PageIndexChanged(ByVal source As Object, ByVal e As System.Web.UI.WebControls.DataGridPageChangedEventArgs)
        grid.CurrentPageIndex = e.NewPageIndex
        BindData()
    End Sub
    
    Sub BindData()
        '- Define data table for folders
        Dim dtFolders As New Data.DataTable("GalleryFolders")
        Dim dcFolderName As New Data.DataColumn("Folder")
        dcFolderName.Caption = "Location"
        dtFolders.Columns.Add(dcFolderName)
        
        '- Define datatable for files
        Dim dt As New Data.DataTable("GalleryFiles")
        Dim dcName As New Data.DataColumn("Location")
        dcName.Caption = "Location"
        dt.Columns.Add(dcName)
        Dim dcSize As New Data.DataColumn("Size")
        dcSize.Caption = "Size"
        dt.Columns.Add(dcSize)
            
        Dim fld As IO.DirectoryInfo = New IO.DirectoryInfo(AppDomain.CurrentDomain.BaseDirectory & "\Gallery")
        If Request("fld") <> "" Then
            fld = New IO.DirectoryInfo(AppDomain.CurrentDomain.BaseDirectory & "/Gallery/" & Request("fld"))
            Dim navFolder As String = Request("fld").Replace(fld.Name, "")
            If navFolder.EndsWith("/") Then navFolder = Mid(navFolder, 1, navFolder.Length - 1)
       
            lnkRoot.Visible = True
            lnkRoot.NavigateUrl = "?fld=" & navFolder
        Else
            lnkRoot.Visible = False
        End If
        
        '- get folders
        For Each folder As IO.DirectoryInfo In fld.GetDirectories
            Dim drFolder As Data.DataRow = dtFolders.NewRow
            drFolder(0) = folder.Name
            dtFolders.Rows.Add(drFolder)
        Next
        listGalleryFolders.DataSource = dtFolders
        listGalleryFolders.DataBind()
         
        '- get files
        For Each path As IO.FileInfo In fld.GetFiles
            Dim dr As Data.DataRow = dt.NewRow
            dr(0) = BuildPath(path.FullName)
            dr(1) = path.Length
            dt.Rows.Add(dr)
        Next
        grid.DataSource = dt
        grid.DataBind()
    End Sub
    
    Public Function FolderName() As String
        If Request("fld") <> "" AndAlso Request("fld") <> "/" Then
            Return Request("fld") & "/"
        Else
            Return ""
        End If
    End Function
</script>

<asp:Content ID="contentGalleryFiles" ContentPlaceHolderID="contentHolder" Runat="Server">
    <magicAjax:AjaxPanel runat="server" ID="ajaxGrid">    
    <asp:DataGrid runat="server" ID="grid" BorderStyle="none" BorderWidth="0"       
        ShowHeader="False" 
        Width="100%" AutoGenerateColumns="False" AllowPaging="True" OnPageIndexChanged="grid_PageIndexChanged" PageSize="5">
        <PagerStyle Mode="NumericPages" />
    
        <Columns>
            <asp:TemplateColumn>
                <ItemTemplate>
                    <a href="<%#urlhome & DataBinder.Eval(Container.DataItem, "Location")%>" target="_blank">
                        <img src="images_thmb.aspx?src=<%#urlhome & DataBinder.Eval(Container.DataItem, "Location")%>&w=320&h=200" alt="" />
                        <br />
                        <%#IO.Path.GetFileName(DataBinder.Eval(Container.DataItem, "Location"))%>, <%#formatnumber(DataBinder.Eval(Container.DataItem, "Size")/1024,2) %> Kb
                    </a>
                </ItemTemplate>
            </asp:TemplateColumn>
        </Columns>
    </asp:DataGrid>
    </magicAjax:AjaxPanel>
</asp:Content>

<asp:Content ID="contentGalleryFolders" ContentPlaceHolderID="contentFolders" runat="server">
    <b><asp:HyperLink ID="lnkHome" runat="server">Gallery</asp:HyperLink></b>    
    <hr />
    <asp:HyperLink ID="lnkRoot" runat="server">...</asp:HyperLink>
    <asp:DataList runat="server" ID="listGalleryFolders" Width="100%">
        <ItemTemplate>
            <a href="?fld=<%#FolderName() & DataBinder.Eval(Container.DataItem, "Folder")%>"><%#DataBinder.Eval(Container.DataItem, "Folder") %></a>
        </ItemTemplate>
    </asp:DataList>
</asp:Content>

