﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using EventCalendar.Presenter;
using System.Web;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EventCalendar.Webservice
{
    public class Events:IHttpHandler,IEventCalendarView
    {       
        private string _selectedYear;
        private EventCalendarPresenter _presenter;
        private HttpContext _context;

        public Events()
        {
            _presenter = new EventCalendarPresenter(this);
        }
        bool IHttpHandler.IsReusable
        {
            get { throw new NotImplementedException(); }
        }

        void IHttpHandler.ProcessRequest(HttpContext context)
        {
            // Expect URl - http://servername.com/VirtualDirectory/EventCalendar?year=selectedYear
            // example - http://localhost/EventCalendarWebService/EventCalendar?year=2010            
            
            _context = context;
            
            _presenter = new EventCalendarPresenter(this);
            _selectedYear = context.Request["year"];
            if (_selectedYear == null)
            {
                _selectedYear = Convert.ToString(DateTime.Now.Year);
            }
            _presenter.UpdateView();
        }      

        string IEventCalendarView.SelectedYear
        {
            get
            { return _selectedYear; }            
        }

        string IEventCalendarView.HTMLCode
        {            
            set
            { _context.Response.Write(value); }
        }        
    }
}
