﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using System.Web;
using EventCalendar.Presenter;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EventCalendar.Webservice
{
    public class DetailedEvent:IHttpHandler,IDetailedEventView
    {        
        private DetailedEventPresenter _presenter;
        private string _selectedYear;
        private string _event;
        private string _month;
        private HttpContext _context;

        bool IHttpHandler.IsReusable
        {
            get { throw new NotImplementedException(); }
        }

        void IHttpHandler.ProcessRequest(HttpContext context)
        {
            _context = context;
            _month = context.Request["month"];
            _event = context.Request["event"];

            _presenter = new DetailedEventPresenter(this);
            _selectedYear = context.Request["year"];
            if (_selectedYear == null)  { _selectedYear = Convert.ToString(DateTime.Now.Year); }
            _presenter.UpdateView();
        }         

        string IDetailedEventView.SelectedYear  {  get { return _selectedYear; } }
        string IDetailedEventView.JSONstring    {  set { _context.Response.Write(value); } }
        string IDetailedEventView.date          {  get { return _event; } }
        int IDetailedEventView.monthid          {  get { return Convert.ToInt16(_month); }  }        
    }
}
