﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using System.Configuration;
using EventCalendar.Presenter;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace EventCalendar.UI
{
    public partial class Events : System.Web.UI.Page, IEventCalendarView
    {
        private EventCalendarPresenter presenter;
        private string _selectedYear;  
        protected void Page_Load(object sender, EventArgs e)
        {            
            presenter = new EventCalendarPresenter(this);
            _selectedYear = Request["year"];
            if (_selectedYear==null)
            {
                _selectedYear = Convert.ToString(DateTime.Now.Year);
            }
            presenter.UpdateView();            
        }        
        
        #region IEventCalendarView Members

        string IEventCalendarView.SelectedYear
        {
            get { return _selectedYear; }
        }

        string IEventCalendarView.HTMLCode
        {
            set { Response.Write(value); }
        }

        #endregion
    }
}
