﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using System.Configuration;
using EventCalendar.Presenter;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace EventCalendar.UI
{
    public partial class DetailedEvent : System.Web.UI.Page, IDetailedEventView
    {
        private DetailedEventPresenter presenter;
        private string _selectedYear;
        private string _event;
        private string _month;        
        protected void Page_Load(object sender, EventArgs e)
        {
            _month = Request["month"];            
            _event = Request["event"];
            
            presenter = new DetailedEventPresenter(this);
            _selectedYear = Request["year"];
            if (_selectedYear == null) { _selectedYear = Convert.ToString(DateTime.Now.Year);}           
            presenter.UpdateView();           

        }             

        string IDetailedEventView.SelectedYear  { get { return _selectedYear; }}
        string IDetailedEventView.JSONstring    { set { Response.Write(value); }}
        string IDetailedEventView.date          { get { return _event; }}
        int IDetailedEventView.monthid          { get { return Convert.ToInt16(_month); }}        
    }
}
