﻿USE [EventCalendar]
GO

/****** Object:  Table [dbo].[Events]    Script Date: 11/02/2010 16:03:06 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE TABLE [dbo].[Events](
	[EventId] [int] IDENTITY(1,1) NOT NULL,
	[Date] [nchar](10),
	[Description] [nvarchar](max),
	[Link] [nchar](50),
	[YearId] [int] NOT NULL,
	[MonthId] [smallint] NOT NULL,
 CONSTRAINT [PK_Events] PRIMARY KEY CLUSTERED 
(
	[EventId] ASC
)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]
) ON [PRIMARY]

GO

ALTER TABLE [dbo].[Events]  WITH CHECK ADD  CONSTRAINT [FK_Events_Months] FOREIGN KEY([MonthId])
REFERENCES [dbo].[Months] ([MonthId])
ON UPDATE CASCADE
ON DELETE CASCADE
GO

ALTER TABLE [dbo].[Events] CHECK CONSTRAINT [FK_Events_Months]
GO

ALTER TABLE [dbo].[Events]  WITH CHECK ADD  CONSTRAINT [FK_Events_Year] FOREIGN KEY([YearId])
REFERENCES [dbo].[Year] ([YearId])
GO

ALTER TABLE [dbo].[Events] CHECK CONSTRAINT [FK_Events_Year]
GO


