﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using System.Collections;
using EventCalendar.Business.Events;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EventCalendar.Presenter
{
    public class EventCalendarPresenter
    {
        IEventCalendarView _view;
        public EventCalendarPresenter(IEventCalendarView view)
        {
            _view = view;
        }
        public void UpdateView()
        {            
            // Initiate Calendar class
            Calendar c = new Calendar();
            c.Year = _view.SelectedYear;
            // Generate HTML code
            _view.HTMLCode = GenerateHTMLCodeForaCalendar(c);

        }

        #region InnerHTML Code
        /// <summary>
        /// Loads Months in a calendar Year and generates HTML code
        /// </summary>
        /// <param name="c"></param>
        /// <returns>HTML Code in string</returns>
        private string GenerateHTMLCodeForaCalendar(Calendar c)
        {
            StringBuilder innerHTML = new StringBuilder();
            innerHTML.Append("<table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"tableEvents\">");
            byte monthCount = 1;
            // Get Names for all the months
            ArrayList arrMonths = new ArrayList();
            for (int monthId = 0; monthId < 12; monthId++)
			{
                Month month = c.Months.Find((m) => { return m.MonthID == monthId + 1; });
                arrMonths.Add("<th>" + month.MonthName + "</th><td></td>");			 
			}
            for (int row = 0; row < 3; row++)
            {                
                // HTML for Row Headers - Month Names
                if (row == 0)
                {
                    // Row 1 Header - Jan, Feb, March, April
                    innerHTML.Append("<tr class=\"head\">");
                    innerHTML.Append(arrMonths[0]); innerHTML.Append(arrMonths[1]); innerHTML.Append(arrMonths[2]); innerHTML.Append(arrMonths[3]);       
                                  
                    innerHTML.Append("</tr>");  
                }

                else if (row == 1)
                {
                    // Row 2 Header - May, June, July, August
                    innerHTML.Append("<tr class=\"head\">");
                    innerHTML.Append(arrMonths[4]); innerHTML.Append(arrMonths[5]); innerHTML.Append(arrMonths[6]); innerHTML.Append(arrMonths[7]);
                    
                    innerHTML.Append("</tr>");
                }
                else
                {
                    // Row 3 Header - Sep, Oct, Nov, December
                    innerHTML.Append("<tr class=\"head\">");
                    innerHTML.Append(arrMonths[8]); innerHTML.Append(arrMonths[9]); innerHTML.Append(arrMonths[10]); innerHTML.Append(arrMonths[11]);
                    
                    innerHTML.Append("</tr>");
                }                    
                
                // HTML for Table Data
                innerHTML.Append("<tr>");                
                for (int col = 0; col < 4; col++)
                {
                    innerHTML.Append("<td class=\"eventCont\"><div class=\"scroll-pane\"><div>");
                    Month month = c.Months.Find((m) => { return (m.MonthID == monthCount); });
                    innerHTML.Append(EventsInaMonth(month));
                    innerHTML.Append("</div></div></td><td>&nbsp;</td>");
                    monthCount += 1;
                }

                innerHTML.Append("</tr>");
            }
            innerHTML.Append("</table>");
            return innerHTML.ToString();
        }
        /// <summary>
        /// Loads Events in a given month
        /// </summary>
        /// <param name="month"></param>
        /// <returns>HTML Code in string</returns>
        private string EventsInaMonth(Month month)
        {
            StringBuilder text = new StringBuilder();
            text.Append("<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"0\">");
            foreach (Event e in month.Events)
            {
                text.Append("<tr>");
                text.Append("<td><strong>");
                text.Append("<a href=\"#");

                if (e.Description != "")
                    text.Append("\" onclick=\"popup('event=" + e.Date + "&month=" + month.MonthID + "&year=" + month.Year + "')\"> ");

                else
                    text.Append("\" onclick=\"popup('month=" + month.MonthID + "&year=" + month.Year + "')\"> ");
                text.Append(e.Date);
                text.Append("</a>");

                text.Append("</strong>");
                text.Append("<p>");
                text.Append(e.Description);
                text.Append("</p></td></tr>");
            }
            text.Append("</table>");
            return text.ToString();
        }
        #endregion
    }
}
