﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using EventCalendar.Business.Events;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace EventCalendar.Presenter
{
    public class DetailedEventPresenter
    {
        private IDetailedEventView  _view;
        List<Month> _months;
        public DetailedEventPresenter(IDetailedEventView view)
        {
            _view = view;
            _months = new List<Month>();

        }

        public void UpdateView()
        {
            int intCurrentYear = DateTime.Now.Year;
            Calendar c = new Calendar();
            c.Year = _view.SelectedYear;
            _months = c.Months;

            Month month = _months.Find((m) => { return (m.MonthID == _view.monthid); });
            Event selectedEvent = month.Events.Find((e) => { return (e.Date == _view.date); });

            //serialize JSON
            //string jsonString = "{'title':'" + selectedEvent.Description.Trim() + "', 'date':'" + selectedEvent.Date.Trim() +
            //    "', 'details':'" + selectedEvent.Details.Trim() + "', 'link':'" + selectedEvent.Link.Trim() + "', 'image':'" + selectedEvent.Image.Trim() + "'}";
            string jsonString = "{'title':'" + selectedEvent.Description + "', 'date':'" + selectedEvent.Date +
                "', 'details':'" + selectedEvent.Details + "', 'link':'" + selectedEvent.Link + "', 'image':'" + selectedEvent.Image + "'}";
            _view.JSONstring = jsonString;
        }
        //public string GetEvent(int monthid, string date)
        //{
        //    Month month = _months.Find((m) => { return (m.MonthID == monthid); });
        //    Event selectedEvent = month.Events.Find((e) => { return (e.Date == date); });

        //    //serialize JSON
        //    string jsonString = "{'title':'" + selectedEvent.Description + "', 'date':'" + selectedEvent.Date +
        //        "', 'details':'" + selectedEvent.Details + "', 'link':'" + selectedEvent.Link + "', 'image':'" + selectedEvent.Image + "'}";
        //    return jsonString;
        //}
    }
}
