﻿// Author - Anshu Dutta
// email - anshu.dutta@gmail.com
using System;
using System.Data;
using System.Collections;

namespace EventCalendar.DataAccessLayer
{
    public class DatabaseGateway
    {        
        public DatabaseGateway() {}
        public DataTable ExecuteQuery(string SQlQuery)
        {
            using (IDatabaseConnection conn = new DatabaseConnection())
            {
                DataSet ds = new DataSet();
                conn.CreateAdapter(conn.CreateCommand(SQlQuery, CommandTypes.Query)).Fill(ds);
                return ds.Tables[0];
            }
        }
        public DataTable ExecuteQuery(string SQlQuery, Hashtable param)
        {
            using (IDatabaseConnection conn = new DatabaseConnection())
            {
                DataSet ds = new DataSet();
                IDbCommand cmd = conn.CreateCommand(SQlQuery, CommandTypes.Query);

                foreach (DictionaryEntry item in param)
                {
                    IDataParameter p = cmd.CreateParameter();
                    p.ParameterName = (string)item.Key;
                    p.Value = item.Value;
                    cmd.Parameters.Add(p);
                }
                conn.CreateAdapter(cmd).Fill(ds);
                return ds.Tables[0];
            }
        }
        public DataTable ExecuteStoredProcedure(string SQlQuery)
        {
            using (IDatabaseConnection conn = new DatabaseConnection())
            {                
                DataSet ds = new DataSet();                
                conn.CreateAdapter(conn.CreateCommand(SQlQuery, CommandTypes.StoredProcedure)).Fill(ds);
                return ds.Tables[0];
            }
        }
        public DataTable ExecuteStoredProcedure(string SQlQuery, Hashtable param)
        {
            using (IDatabaseConnection conn = new DatabaseConnection())
            {
                DataSet ds = new DataSet();
                IDbCommand cmd = conn.CreateCommand(SQlQuery, CommandTypes.StoredProcedure);
                
                foreach (DictionaryEntry item in param)
                {
                    IDataParameter p = cmd.CreateParameter();
                    p.ParameterName = (string)item.Key;
                    p.Value = item.Value;
                    cmd.Parameters.Add(p);
                }
                conn.CreateAdapter(cmd).Fill(ds);
                return ds.Tables[0];
            }
        }
    }
}
